/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication;

import io.inverno.mod.security.authentication.Authentication;
import io.inverno.mod.security.authentication.AuthenticationException;
import io.inverno.mod.security.authentication.Credentials;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface Authenticator<A extends Credentials, B extends Authentication> {
    public Mono<B> authenticate(A var1) throws AuthenticationException;

    default public Authenticator<A, B> or(Authenticator<? super A, ? extends B> other) {
        return credentials -> this.authenticate(credentials).switchIfEmpty(other.authenticate(credentials));
    }

    default public <T extends Authentication> Authenticator<A, T> flatMap(Function<? super B, ? extends Mono<? extends T>> mapper) {
        return credentials -> this.authenticate(credentials).flatMap(mapper);
    }

    default public <T extends Authentication> Authenticator<A, T> map(Function<? super B, ? extends T> mapper) {
        return credentials -> this.authenticate(credentials).map(mapper);
    }

    default public Authenticator<A, B> failOnDenied() {
        return credentials -> this.authenticate(credentials).doOnNext(authentication -> authentication.getCause().ifPresent(e -> {
            throw e;
        }));
    }

    default public Authenticator<A, B> failOnDeniedAndAnonymous() {
        return credentials -> this.authenticate(credentials).doOnNext(authentication -> authentication.getCause().ifPresentOrElse(e -> {
            throw e;
        }, () -> {
            if (!authentication.isAuthenticated()) {
                throw new AuthenticationException("Anonymous authentication not allowed");
            }
        }));
    }
}

