/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.inverno.mod.security.SecurityException;
import io.inverno.mod.security.internal.authentication.GenericAuthentication;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(as=GenericAuthentication.class)
@JsonIgnoreProperties(value={"anonymous"}, allowGetters=true)
public interface Authentication {
    public static Authentication anonymous() {
        return GenericAuthentication.ANONYMOUS;
    }

    public static Authentication granted() {
        return GenericAuthentication.GRANTED;
    }

    public static Authentication denied() {
        return GenericAuthentication.DENIED;
    }

    public static Authentication denied(SecurityException cause) {
        return new GenericAuthentication(cause);
    }

    @JsonProperty(value="authenticated")
    public boolean isAuthenticated();

    @JsonProperty(value="anonymous")
    default public boolean isAnonymous() {
        return !this.isAuthenticated() && !this.getCause().isPresent();
    }

    @JsonIgnore
    public Optional<SecurityException> getCause();
}

