/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.authentication;

import io.inverno.mod.security.authentication.AuthenticationException;
import io.inverno.mod.security.authentication.Authenticator;
import io.inverno.mod.security.authentication.Credentials;
import io.inverno.mod.security.authentication.CredentialsMatcher;
import io.inverno.mod.security.authentication.CredentialsNotFoundException;
import io.inverno.mod.security.authentication.CredentialsResolver;
import io.inverno.mod.security.authentication.InvalidCredentialsException;
import io.inverno.mod.security.authentication.PrincipalAuthentication;
import io.inverno.mod.security.authentication.PrincipalCredentials;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reactor.core.publisher.Mono;

public abstract class AbstractPrincipalAuthenticator<A extends PrincipalCredentials, B extends Credentials, C extends PrincipalAuthentication>
implements Authenticator<A, C> {
    private static final Logger LOGGER = LogManager.getLogger(AbstractPrincipalAuthenticator.class);
    protected final CredentialsResolver<? extends B> credentialsResolver;
    protected final CredentialsMatcher<? super A, ? super B> credentialsMatcher;
    private boolean terminal;

    protected AbstractPrincipalAuthenticator(CredentialsResolver<? extends B> credentialsResolver, CredentialsMatcher<? super A, ? super B> credentialsMatcher) {
        this.credentialsResolver = credentialsResolver;
        this.credentialsMatcher = credentialsMatcher;
        this.terminal = true;
    }

    public void setTerminal(boolean terminal) {
        this.terminal = terminal;
    }

    @Override
    public Mono<C> authenticate(A credentials) {
        return this.credentialsResolver.resolveCredentials(credentials.getUsername()).switchIfEmpty(Mono.error(() -> new CredentialsNotFoundException("Credentials not found"))).map(resolvedCredentials -> {
            if (!this.credentialsMatcher.matches((PrincipalCredentials)credentials, (Credentials)resolvedCredentials)) {
                throw new InvalidCredentialsException("Invalid credentials");
            }
            return this.createAuthenticated(resolvedCredentials);
        }).onErrorResume(AuthenticationException.class, e -> {
            if (!this.terminal) {
                LOGGER.error("Failed to authenticate", (Throwable)e);
                return Mono.empty();
            }
            return Mono.just(this.createDenied(credentials, (AuthenticationException)e));
        });
    }

    protected abstract C createAuthenticated(B var1) throws AuthenticationException;

    protected abstract C createDenied(A var1, AuthenticationException var2) throws AuthenticationException;
}

