/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.accesscontrol;

import io.inverno.mod.security.accesscontrol.AccessController;
import io.inverno.mod.security.internal.accesscontrol.GenericRoleBasedAccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public interface RoleBasedAccessController
extends AccessController {
    public Mono<Boolean> hasRole(String var1);

    default public Mono<Boolean> hasAnyRole(String ... roles) {
        return this.hasAnyRole(roles != null ? Arrays.asList(roles) : List.of());
    }

    public Mono<Boolean> hasAnyRole(Collection<String> var1);

    default public Mono<Boolean> hasAllRoles(String ... roles) {
        return this.hasAllRoles(roles != null ? Arrays.asList(roles) : List.of());
    }

    public Mono<Boolean> hasAllRoles(Collection<String> var1);

    public static RoleBasedAccessController of(String ... roles) {
        return new GenericRoleBasedAccessController(Arrays.stream(roles).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public static RoleBasedAccessController of(Collection<String> roles) {
        return new GenericRoleBasedAccessController(roles.stream().filter(Objects::nonNull).collect(Collectors.toSet()));
    }
}

