/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.accesscontrol;

import io.inverno.mod.configuration.ConfigurationSource;
import io.inverno.mod.security.accesscontrol.AccessControlException;
import io.inverno.mod.security.accesscontrol.AccessControllerResolver;
import io.inverno.mod.security.accesscontrol.ConfigurationSourcePermissionBasedAccessController;
import io.inverno.mod.security.accesscontrol.PermissionBasedAccessController;
import io.inverno.mod.security.authentication.GroupAwareAuthentication;
import io.inverno.mod.security.authentication.PrincipalAuthentication;
import reactor.core.publisher.Mono;

public class ConfigurationSourcePermissionBasedAccessControllerResolver
implements AccessControllerResolver<PrincipalAuthentication, PermissionBasedAccessController> {
    private final ConfigurationSource<?, ?, ?> configurationSource;
    private final String rolePrefix;

    public ConfigurationSourcePermissionBasedAccessControllerResolver(ConfigurationSource<?, ?, ?> configurationSource) {
        this(configurationSource, null);
    }

    public ConfigurationSourcePermissionBasedAccessControllerResolver(ConfigurationSource<?, ?, ?> configurationSource, String rolePrefix) {
        this.configurationSource = configurationSource;
        this.rolePrefix = rolePrefix;
    }

    @Override
    public Mono<PermissionBasedAccessController> resolveAccessController(PrincipalAuthentication authentication) throws AccessControlException {
        return Mono.justOrEmpty((Object)authentication).map(auth -> new ConfigurationSourcePermissionBasedAccessController(this.configurationSource, auth.getUsername(), auth instanceof GroupAwareAuthentication ? ((GroupAwareAuthentication)((Object)auth)).getGroups() : null, this.rolePrefix));
    }
}

