/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.accesscontrol;

import io.inverno.mod.configuration.ConfigurationKey;
import io.inverno.mod.configuration.ConfigurationSource;
import io.inverno.mod.security.accesscontrol.PermissionBasedAccessController;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ConfigurationSourcePermissionBasedAccessController
implements PermissionBasedAccessController {
    public static final String DEFAULT_ROLE_PREFIX = "ROLE_";
    private final ConfigurationSource<?, ?, ?> configurationSource;
    private final String username;
    private final Set<String> roles;
    private final String rolePrefix;

    public ConfigurationSourcePermissionBasedAccessController(ConfigurationSource<?, ?, ?> configurationSource, String username) {
        this(configurationSource, username, null, DEFAULT_ROLE_PREFIX);
    }

    public ConfigurationSourcePermissionBasedAccessController(ConfigurationSource<?, ?, ?> configurationSource, String username, Set<String> roles) {
        this(configurationSource, username, roles, DEFAULT_ROLE_PREFIX);
    }

    public ConfigurationSourcePermissionBasedAccessController(ConfigurationSource<?, ?, ?> configurationSource, String username, Set<String> roles, String rolePrefix) {
        Objects.requireNonNull(configurationSource);
        Objects.requireNonNull(username);
        this.configurationSource = configurationSource;
        this.username = username;
        this.rolePrefix = rolePrefix != null ? rolePrefix : DEFAULT_ROLE_PREFIX;
        this.roles = roles != null ? roles.stream().map(role -> this.rolePrefix + role).collect(Collectors.toSet()) : Set.of();
    }

    public final String getRolePrefix() {
        return this.rolePrefix;
    }

    private boolean hasPermission(String permission, Set<String> resolvedPermissions) {
        return resolvedPermissions != null && (resolvedPermissions.contains(permission) || resolvedPermissions.contains("*")) && !resolvedPermissions.contains("!" + permission);
    }

    private boolean hasAnyPermission(Set<String> permissions, Set<String> resolvedPermissions) {
        return permissions.stream().anyMatch(permission -> this.hasPermission((String)permission, resolvedPermissions));
    }

    private boolean hasAllPermissions(Set<String> permissions, Set<String> resolvedPermissions) {
        return permissions.stream().allMatch(permission -> this.hasPermission((String)permission, resolvedPermissions));
    }

    private Mono<Set<String>> resolvePermissions(String usernameOrRole, List<ConfigurationKey.Parameter> parameters) {
        return this.configurationSource.get(new String[]{usernameOrRole}).withParameters(parameters.stream().map(parameter -> ConfigurationKey.Parameter.of((String)parameter.getKey(), (Object)parameter.getValue())).collect(Collectors.toList())).execute().single().mapNotNull(result -> result.getResult().flatMap(property -> property.asSetOf(String.class)).orElse(null));
    }

    @Override
    public Mono<Boolean> hasPermission(String permission, List<PermissionBasedAccessController.Parameter> parameters) {
        List<ConfigurationKey.Parameter> configurationParameters = parameters.stream().map(parameter -> ConfigurationKey.Parameter.of((String)parameter.getKey(), (Object)parameter.getValue())).collect(Collectors.toList());
        return this.resolvePermissions(this.username, configurationParameters).map(userPermissions -> this.hasPermission(permission, (Set<String>)userPermissions)).switchIfEmpty(Flux.fromIterable(this.roles).concatMap(role -> this.resolvePermissions((String)role, configurationParameters)).map(rolePermissions -> this.hasPermission(permission, (Set<String>)rolePermissions)).filter(granted -> granted).next()).switchIfEmpty(Mono.just((Object)false));
    }

    @Override
    public Mono<Boolean> hasAnyPermission(Set<String> permissions, List<PermissionBasedAccessController.Parameter> parameters) {
        List<ConfigurationKey.Parameter> configurationParameters = parameters.stream().map(parameter -> ConfigurationKey.Parameter.of((String)parameter.getKey(), (Object)parameter.getValue())).collect(Collectors.toList());
        return this.resolvePermissions(this.username, configurationParameters).map(userPermissions -> this.hasAnyPermission(permissions, (Set<String>)userPermissions)).switchIfEmpty(Flux.fromIterable(this.roles).concatMap(role -> this.resolvePermissions((String)role, configurationParameters)).map(rolePermissions -> this.hasAnyPermission(permissions, (Set<String>)rolePermissions)).filter(granted -> granted).next()).switchIfEmpty(Mono.just((Object)false));
    }

    @Override
    public Mono<Boolean> hasAllPermissions(Set<String> permissions, List<PermissionBasedAccessController.Parameter> parameters) {
        List<ConfigurationKey.Parameter> configurationParameters = parameters.stream().map(parameter -> ConfigurationKey.Parameter.of((String)parameter.getKey(), (Object)parameter.getValue())).collect(Collectors.toList());
        return this.resolvePermissions(this.username, configurationParameters).map(userPermissions -> this.hasAllPermissions(permissions, (Set<String>)userPermissions)).switchIfEmpty(Flux.fromIterable(this.roles).concatMap(role -> this.resolvePermissions((String)role, configurationParameters)).map(rolePermissions -> this.hasAllPermissions(permissions, (Set<String>)rolePermissions)).filter(granted -> granted).next()).switchIfEmpty(Mono.just((Object)false));
    }
}

