/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security;

import io.inverno.mod.security.accesscontrol.AccessController;
import io.inverno.mod.security.accesscontrol.AccessControllerResolver;
import io.inverno.mod.security.authentication.Authentication;
import io.inverno.mod.security.authentication.Authenticator;
import io.inverno.mod.security.authentication.Credentials;
import io.inverno.mod.security.context.SecurityContext;
import io.inverno.mod.security.identity.Identity;
import io.inverno.mod.security.identity.IdentityResolver;
import io.inverno.mod.security.internal.GenericSecurityManager;
import reactor.core.publisher.Mono;

public interface SecurityManager<A extends Credentials, B extends Identity, C extends AccessController> {
    public static <A extends Credentials, B extends Authentication, C extends Identity, D extends AccessController> SecurityManager<A, C, D> of(Authenticator<? super A, ? extends B> authenticator) {
        return new GenericSecurityManager(authenticator);
    }

    public static <A extends Credentials, B extends Authentication, C extends Identity, D extends AccessController> SecurityManager<A, C, D> of(Authenticator<? super A, ? extends B> authenticator, IdentityResolver<? super B, ? extends C> identityResolver) {
        return new GenericSecurityManager(authenticator, identityResolver);
    }

    public static <A extends Credentials, B extends Authentication, C extends Identity, D extends AccessController> SecurityManager<A, C, D> of(Authenticator<? super A, ? extends B> authenticator, AccessControllerResolver<? super B, ? extends D> accessControllerResolver) {
        return new GenericSecurityManager(authenticator, accessControllerResolver);
    }

    public static <A extends Credentials, B extends Authentication, C extends Identity, D extends AccessController> SecurityManager<A, C, D> of(Authenticator<? super A, ? extends B> authenticator, IdentityResolver<? super B, ? extends C> identityResolver, AccessControllerResolver<? super B, ? extends D> accessControllerResolver) {
        return new GenericSecurityManager<A, B, C, D>(authenticator, identityResolver, accessControllerResolver);
    }

    public Mono<SecurityContext<B, C>> authenticate(A var1);
}

