/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.form;

import io.inverno.mod.base.converter.Convertible;
import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.HttpException;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeHandler;
import io.inverno.mod.http.server.Request;
import io.inverno.mod.http.server.Response;
import io.inverno.mod.security.http.form.LoginView;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class FormLoginPageHandler<A extends ExchangeContext, B extends Exchange<A>>
implements ExchangeHandler<A, B> {
    public static final String DEFAULT_LOGIN_ACTION_URI = "/login";
    public static final String PARAMETER_REDIRECT_URI = "redirect_uri";
    public static final String PARAMETER_ERROR = "error";
    private static final LoginView.Renderer<CompletableFuture<String>> LOGIN_PAGE_RENDERER = LoginView.string();
    private final String loginActionUri;

    public FormLoginPageHandler() {
        this(DEFAULT_LOGIN_ACTION_URI);
    }

    public FormLoginPageHandler(String loginActionUri) {
        this.loginActionUri = loginActionUri;
    }

    public String getLoginActionUri() {
        return this.loginActionUri;
    }

    public void handle(B exchange) throws HttpException {
        String redirect_uri = ((Request)exchange.request()).queryParameters().get(PARAMETER_REDIRECT_URI).map(Convertible::asString).orElse(null);
        String error = ((Request)exchange.request()).queryParameters().get(PARAMETER_ERROR).map(Convertible::asString).orElse(null);
        ((Response)exchange.response()).headers(headers -> headers.contentType("text/html")).body().string().stream((Publisher)Mono.fromFuture(LOGIN_PAGE_RENDERER.render(this.loginActionUri, redirect_uri, error)));
    }
}

