/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.digest;

import io.inverno.mod.http.base.Method;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.Request;
import io.inverno.mod.security.http.CredentialsExtractor;
import io.inverno.mod.security.http.MalformedCredentialsException;
import io.inverno.mod.security.http.digest.DigestCredentials;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import reactor.core.publisher.Mono;

public class DigestCredentialsExtractor
implements CredentialsExtractor<DigestCredentials> {
    private static final String PARAMETER_ALGORITHM = "algorithm";
    private static final String PARAMETER_RESPONSE = "response";
    private static final String PARAMETER_USERNAME = "username";
    private static final String PARAMETER_USERNAME_EXT = "username*";
    private static final String PARAMETER_USERHASH = "userhash";
    private static final String PARAMETER_REALM = "realm";
    private static final String PARAMETER_URI = "uri";
    private static final String PARAMETER_QOP = "qop";
    private static final String PARAMETER_CNONCE = "cnonce";
    private static final String PARAMETER_NC = "nc";
    private static final String PARAMETER_NONCE = "nonce";

    @Override
    public Mono<DigestCredentials> extract(Exchange<?> exchange) throws MalformedCredentialsException {
        return Mono.fromSupplier(() -> ((Request)exchange.request()).headers().getHeader((CharSequence)"authorization").filter(authorizationHeader -> authorizationHeader.getAuthScheme().equals("digest")).map(authorizationHeader -> DigestCredentialsExtractor.from(authorizationHeader, ((Request)exchange.request()).getMethod())).orElse(null));
    }

    private static DigestCredentials from(Headers.Authorization authorizationHeader, Method method) throws MalformedCredentialsException {
        String algorithm = null;
        String response = null;
        String username = null;
        String realm = null;
        String uri = null;
        String qop = null;
        String cnonce = null;
        String nc = null;
        String nonce = null;
        boolean userhash = false;
        for (Map.Entry p : authorizationHeader.getParameters().entrySet()) {
            String name = (String)p.getKey();
            String value = (String)p.getValue();
            switch (name) {
                case "algorithm": {
                    algorithm = value;
                    break;
                }
                case "response": {
                    response = value;
                    break;
                }
                case "username": {
                    if (username != null) {
                        throw new MalformedCredentialsException("You can't specify both username and username*");
                    }
                    username = StringEscapeUtils.unescapeJava((String)value);
                    break;
                }
                case "username*": {
                    if (username != null) {
                        throw new MalformedCredentialsException("You can't specify both username and username*");
                    }
                    String[] splitValue = value.split("'");
                    if (splitValue.length != 3) {
                        throw new MalformedCredentialsException("Invalid extended username*: " + value + ", expected: charset \"'\" [ language ] \"'\" value-chars");
                    }
                    String charset = splitValue[0];
                    String language = splitValue[1];
                    String pctValue = splitValue[2];
                    try {
                        username = URLDecoder.decode(pctValue, charset);
                        break;
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new MalformedCredentialsException("Invalid charset in extended username*: " + charset);
                    }
                }
                case "realm": {
                    realm = StringEscapeUtils.unescapeJava((String)value);
                    break;
                }
                case "uri": {
                    uri = value;
                    break;
                }
                case "qop": {
                    qop = value;
                    break;
                }
                case "cnonce": {
                    cnonce = value;
                    break;
                }
                case "nc": {
                    nc = value;
                    break;
                }
                case "nonce": {
                    nonce = value;
                    break;
                }
                case "userhash": {
                    userhash = Boolean.valueOf(value);
                }
            }
        }
        return new DigestCredentials(method.name(), uri, realm, username, userhash, algorithm, qop, nc, cnonce, nonce, response);
    }
}

