/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.token;

import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.security.accesscontrol.AccessController;
import io.inverno.mod.security.authentication.Authentication;
import io.inverno.mod.security.http.context.SecurityContext;
import io.inverno.mod.security.http.login.LogoutSuccessHandler;
import io.inverno.mod.security.identity.Identity;
import reactor.core.publisher.Mono;

public class CookieTokenLogoutSuccessHandler<A extends Authentication, B extends Identity, C extends AccessController, D extends SecurityContext<B, C>, E extends Exchange<D>>
implements LogoutSuccessHandler<A, B, C, D, E> {
    private final String path;
    private final String tokenCookie;

    public CookieTokenLogoutSuccessHandler() {
        this("/", "AUTH-TOKEN");
    }

    public CookieTokenLogoutSuccessHandler(String path) {
        this(path, "AUTH-TOKEN");
    }

    public CookieTokenLogoutSuccessHandler(String path, String tokenCookie) {
        this.path = path;
        this.tokenCookie = tokenCookie;
    }

    public String getPath() {
        return this.path;
    }

    public String getTokenCookie() {
        return this.tokenCookie;
    }

    @Override
    public Mono<Void> handleLogoutSuccess(E exchange, A authentication) {
        return Mono.fromRunnable(() -> exchange.response().cookies(cookies -> cookies.addCookie(cookie -> cookie.path(this.path).name(this.tokenCookie).value("").maxAge(0))));
    }
}

