/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.token;

import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.security.authentication.TokenCredentials;
import io.inverno.mod.security.http.CredentialsExtractor;
import io.inverno.mod.security.http.MalformedCredentialsException;
import reactor.core.publisher.Mono;

public class CookieTokenCredentialsExtractor
implements CredentialsExtractor<TokenCredentials> {
    public static final String DEFAULT_COOKIE_NAME = "AUTH-TOKEN";
    private final String tokenCookie;

    public CookieTokenCredentialsExtractor() {
        this(DEFAULT_COOKIE_NAME);
    }

    public CookieTokenCredentialsExtractor(String tokenCookie) {
        this.tokenCookie = tokenCookie;
    }

    public String getTokenCookie() {
        return this.tokenCookie;
    }

    @Override
    public Mono<TokenCredentials> extract(Exchange<?> exchange) throws MalformedCredentialsException {
        return Mono.fromSupplier(() -> exchange.request().cookies().get(this.tokenCookie).map(cookie -> new TokenCredentials(cookie.asString())).orElse(null));
    }
}

