/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.form;

import io.inverno.mod.http.base.Status;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.security.accesscontrol.AccessController;
import io.inverno.mod.security.authentication.Authentication;
import io.inverno.mod.security.http.context.SecurityContext;
import io.inverno.mod.security.http.login.LogoutSuccessHandler;
import io.inverno.mod.security.identity.Identity;
import reactor.core.publisher.Mono;

public class RedirectLogoutSuccessHandler<A extends Authentication, B extends Identity, C extends AccessController, D extends SecurityContext<B, C>, E extends Exchange<D>>
implements LogoutSuccessHandler<A, B, C, D, E> {
    public static final String DEFAULT_LOGOUT_SUCCESS_URI = "/";
    private final String logoutSuccessUri;

    public RedirectLogoutSuccessHandler() {
        this(DEFAULT_LOGOUT_SUCCESS_URI);
    }

    public RedirectLogoutSuccessHandler(String loginSuccessUri) {
        this.logoutSuccessUri = loginSuccessUri;
    }

    public String getLogoutSuccessUri() {
        return this.logoutSuccessUri;
    }

    @Override
    public Mono<Void> handleLogoutSuccess(E exchange, A authentication) {
        return Mono.fromRunnable(() -> exchange.response().headers(headers -> headers.status(Status.FOUND).set((CharSequence)"location", (CharSequence)this.logoutSuccessUri)).body().empty());
    }
}

