/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.form;

import io.inverno.mod.base.net.URIBuilder;
import io.inverno.mod.base.net.URIs;
import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.Status;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.RequestBody;
import io.inverno.mod.security.SecurityException;
import io.inverno.mod.security.http.login.LoginFailureHandler;
import reactor.core.publisher.Mono;

public class RedirectLoginFailureHandler<A extends ExchangeContext, B extends Exchange<A>>
implements LoginFailureHandler<A, B> {
    public static final String DEFAULT_LOGIN_FAILURE_URI = "/login";
    private final String loginFailureUri;

    public RedirectLoginFailureHandler() {
        this(DEFAULT_LOGIN_FAILURE_URI);
    }

    public RedirectLoginFailureHandler(String loginFailureUri) {
        this.loginFailureUri = loginFailureUri;
    }

    public String getLoginFailureUri() {
        return this.loginFailureUri;
    }

    @Override
    public Mono<Void> handleLoginFailure(B exchange, SecurityException error) {
        return ((RequestBody)exchange.request().body().get()).urlEncoded().collectMap().flatMap(parameterMap -> {
            URIBuilder failureUriBuilder = URIs.uri((String)this.loginFailureUri, (URIs.Option[])new URIs.Option[0]);
            failureUriBuilder.queryParameter("error", error.getClass().getSimpleName() + ": " + error.getMessage());
            Parameter redirectUri = (Parameter)parameterMap.get("redirect_uri");
            if (redirectUri != null) {
                failureUriBuilder.queryParameter("redirect_uri", (String)redirectUri.getValue());
            }
            exchange.response().headers(headers -> headers.status(Status.FOUND).set((CharSequence)"location", (CharSequence)failureUriBuilder.buildString(new Object[0]))).body().empty();
            return Mono.empty();
        });
    }
}

