/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.digest;

import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.security.SecurityException;
import io.inverno.mod.security.http.HttpAuthenticationErrorInterceptor;
import io.inverno.mod.security.http.digest.DigestUtils;
import io.inverno.mod.security.http.digest.ExpiredNonceException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class DigestAuthenticationErrorInterceptor<A extends ExchangeContext, B extends ErrorExchange<A>>
extends HttpAuthenticationErrorInterceptor<A, B> {
    public static final String ALGORITHM_MD5 = "MD5";
    public static final String ALGORITHM_SHA_256 = "SHA-256";
    public static final String ALGORITHM_SHA_512_256 = "SHA-512-256";
    public static final long DEFAULT_NONCE_VALIDITY_SECONDS = 300L;
    private static final String PARAMETER_REALM = "realm";
    private static final String PARAMETER_QOP = "qop";
    private static final String PARAMETER_NONCE = "nonce";
    private static final String PARAMETER_ALGORITHM = "algorithm";
    private static final String PARAMETER_STALE = "stale";
    private static final String VALUE_QOP_AUTH = "auth";
    private static final String VALUE_QOP_AUTH_INT = "auth-int";
    private static final String FORMAT_WWW_AUTHENTICATE = "digest realm=\"%s\",qop=\"%s\",nonce=\"%s\",algorithm=%s";
    private static final String FORMAT_WWW_AUTHENTICATE_STALE = "digest realm=\"%s\",qop=\"%s\",nonce=\"%s\",algorithm=%s,stale=%s";
    private final MessageDigest digest;
    private final String realm;
    private final String secret;
    private long nonceValiditySeconds = 300L;

    public DigestAuthenticationErrorInterceptor(String realm, String secret) {
        this(realm, secret, ALGORITHM_MD5);
    }

    public DigestAuthenticationErrorInterceptor(String realm, String secret, String algorithm) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)realm)) {
            throw new IllegalArgumentException("realm is null or empty");
        }
        if (StringUtils.isBlank((CharSequence)secret)) {
            throw new IllegalArgumentException("secret is null or empty");
        }
        try {
            this.digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Invalid nonce algorithm: " + algorithm, e);
        }
        this.realm = realm;
        this.secret = secret;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getAlgorithm() {
        return this.digest.getAlgorithm();
    }

    public void setNonceValiditySeconds(long nonceValiditySeconds) {
        this.nonceValiditySeconds = nonceValiditySeconds;
    }

    public long getNonceValiditySeconds() {
        return this.nonceValiditySeconds;
    }

    @Override
    protected String createChallenge(SecurityException cause) {
        long nonceExpire = System.nanoTime() + this.nonceValiditySeconds * 1000000000L;
        String nonce = nonceExpire + ":" + DigestUtils.kd(this.digest, this.secret, Long.toString(nonceExpire));
        String nonceB64 = Base64.getEncoder().encodeToString(nonce.getBytes());
        if (cause instanceof ExpiredNonceException) {
            return String.format(FORMAT_WWW_AUTHENTICATE_STALE, StringEscapeUtils.escapeJava((String)this.realm), VALUE_QOP_AUTH, nonceB64, this.digest.getAlgorithm(), true);
        }
        return String.format(FORMAT_WWW_AUTHENTICATE, StringEscapeUtils.escapeJava((String)this.realm), VALUE_QOP_AUTH, nonceB64, this.digest.getAlgorithm(), StringEscapeUtils.escapeJava((String)this.realm));
    }
}

