/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.token;

import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.security.authentication.TokenAuthentication;
import io.inverno.mod.security.http.login.LoginSuccessHandler;
import reactor.core.publisher.Mono;

public class CookieTokenLoginSuccessHandler<A extends TokenAuthentication, B extends ExchangeContext, C extends Exchange<B>>
implements LoginSuccessHandler<A, B, C> {
    public static final String DEFAULT_PATH = "/";
    private final String path;
    private final String tokenCookie;

    public CookieTokenLoginSuccessHandler() {
        this(DEFAULT_PATH, "AUTH-TOKEN");
    }

    public CookieTokenLoginSuccessHandler(String path) {
        this(path, "AUTH-TOKEN");
    }

    public CookieTokenLoginSuccessHandler(String path, String tokenCookie) {
        this.path = path;
        this.tokenCookie = tokenCookie;
    }

    public String getPath() {
        return this.path;
    }

    public String getTokenCookie() {
        return this.tokenCookie;
    }

    @Override
    public Mono<Void> handleLoginSuccess(C exchange, A authentication) {
        return Mono.fromRunnable(() -> exchange.response().cookies(cookies -> cookies.addCookie(cookie -> cookie.path(this.path).secure("https".equals(exchange.request().getScheme())).httpOnly(true).name(this.tokenCookie).value(authentication.getToken()))));
    }
}

