/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.digest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.inverno.mod.security.authentication.password.AbstractPassword;
import io.inverno.mod.security.authentication.password.Password;
import io.inverno.mod.security.authentication.password.PasswordException;
import io.inverno.mod.security.http.digest.DigestUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public class DigestPassword
extends AbstractPassword<DigestPassword, Encoder> {
    @JsonCreator
    public DigestPassword(@JsonProperty(value="value") String encoded, @JsonProperty(value="encoder") Encoder encoder) {
        super(encoded, (Password.Encoder)encoder);
    }

    public class Encoder
    implements Password.Encoder<DigestPassword, Encoder> {
        @JsonIgnore
        private final String algorithm;
        @JsonIgnore
        private final String username;
        @JsonIgnore
        private final String realm;
        @JsonIgnore
        private MessageDigest digest;

        @JsonCreator
        public Encoder(@JsonProperty(value="username") String algorithm, @JsonProperty(value="realm") String username, String realm) {
            this.algorithm = Objects.requireNonNull(algorithm);
            this.username = Objects.requireNonNull(username);
            this.realm = Objects.requireNonNull(realm);
        }

        @JsonProperty(value="algorithm")
        public String getAlgorithm() {
            return this.algorithm;
        }

        @JsonProperty(value="username")
        public String getUsername() {
            return this.username;
        }

        @JsonProperty(value="realm")
        public String getRealm() {
            return this.realm;
        }

        public DigestPassword recover(String encoded) throws PasswordException {
            return new DigestPassword(encoded, this);
        }

        public DigestPassword encode(String raw) throws PasswordException {
            if (this.digest == null) {
                try {
                    this.digest = MessageDigest.getInstance(this.algorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new PasswordException((Throwable)e);
                }
            }
            return new DigestPassword(DigestUtils.h(this.digest, this.username + ":" + this.realm + ":" + raw), this);
        }

        public boolean matches(String raw, String encoded) throws PasswordException {
            return this.encode(raw).getValue().equals(encoded);
        }
    }
}

