/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http;

import io.inverno.mod.http.base.ForbiddenException;
import io.inverno.mod.http.base.UnauthorizedException;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeInterceptor;
import io.inverno.mod.security.accesscontrol.AccessController;
import io.inverno.mod.security.authentication.Authentication;
import io.inverno.mod.security.http.context.SecurityContext;
import io.inverno.mod.security.identity.Identity;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public class AccessControlInterceptor<A extends Identity, B extends AccessController, C extends SecurityContext<A, B>, D extends Exchange<C>>
implements ExchangeInterceptor<C, D> {
    private final Function<SecurityContext<A, B>, Mono<Boolean>> accessVerifier;

    private AccessControlInterceptor(Function<SecurityContext<A, B>, Mono<Boolean>> accessVerifier) {
        this.accessVerifier = accessVerifier;
    }

    public static <A extends Identity, B extends AccessController, C extends SecurityContext<A, B>, D extends Exchange<C>> AccessControlInterceptor<A, B, C, D> anonymous() {
        return new AccessControlInterceptor<A, B, C, D>(context -> Mono.fromSupplier(() -> {
            Authentication authentication = context.getAuthentication();
            return authentication.isAuthenticated();
        }));
    }

    public static <A extends Identity, B extends AccessController, C extends SecurityContext<A, B>, D extends Exchange<C>> AccessControlInterceptor<A, B, C, D> authenticated() {
        return new AccessControlInterceptor<A, B, C, D>(context -> Mono.fromSupplier(() -> {
            Authentication authentication = context.getAuthentication();
            if (!authentication.isAuthenticated()) {
                throw authentication.getCause().map(UnauthorizedException::new).orElseGet(() -> new UnauthorizedException());
            }
            return true;
        }));
    }

    public static <A extends Identity, B extends AccessController, C extends SecurityContext<A, B>, D extends Exchange<C>> AccessControlInterceptor<A, B, C, D> verify(Function<SecurityContext<A, B>, Mono<Boolean>> accessVerifier) {
        return new AccessControlInterceptor<A, B, C, D>(accessVerifier);
    }

    public Mono<? extends D> intercept(D exchange) {
        return this.accessVerifier.apply((SecurityContext)exchange.context()).map(granted -> {
            if (!granted.booleanValue()) {
                throw new ForbiddenException("Access denied");
            }
            return exchange;
        });
    }
}

