/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.login;

import io.inverno.mod.http.base.HttpException;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeHandler;
import io.inverno.mod.security.accesscontrol.AccessController;
import io.inverno.mod.security.authentication.Authentication;
import io.inverno.mod.security.authentication.AuthenticationReleaser;
import io.inverno.mod.security.http.context.SecurityContext;
import io.inverno.mod.security.http.login.LogoutSuccessHandler;
import io.inverno.mod.security.identity.Identity;
import reactor.core.publisher.Mono;

public class LogoutActionHandler<A extends Authentication, B extends Identity, C extends AccessController, D extends SecurityContext<B, C>, E extends Exchange<D>>
implements ExchangeHandler<D, E> {
    private final AuthenticationReleaser<A> authenticationReleaser;
    private final LogoutSuccessHandler<A, B, C, D, E> logoutSuccessHandler;

    public LogoutActionHandler(AuthenticationReleaser<A> authenticationReleaser) {
        this(authenticationReleaser, null);
    }

    public LogoutActionHandler(AuthenticationReleaser<A> authenticationReleaser, LogoutSuccessHandler<A, B, C, D, E> logoutSuccessHandler) {
        this.authenticationReleaser = authenticationReleaser;
        this.logoutSuccessHandler = logoutSuccessHandler;
    }

    public AuthenticationReleaser<A> getAuthenticationReleaser() {
        return this.authenticationReleaser;
    }

    public LogoutSuccessHandler<A, B, C, D, E> getLogoutSuccessHandler() {
        return this.logoutSuccessHandler;
    }

    public Mono<Void> defer(E exchange) {
        Authentication authentication = ((SecurityContext)exchange.context()).getAuthentication();
        Mono result = this.authenticationReleaser.release(authentication);
        if (this.logoutSuccessHandler != null) {
            result = result.then(this.logoutSuccessHandler.handleLogoutSuccess(exchange, authentication));
        }
        return result;
    }

    public void handle(E exchange) throws HttpException {
        throw new UnsupportedOperationException();
    }
}

