/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.login;

import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeContext;
import io.inverno.mod.security.authentication.Authentication;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface LoginSuccessHandler<A extends Authentication, B extends ExchangeContext, C extends Exchange<B>> {
    public Mono<Void> handleLoginSuccess(C var1, A var2);

    default public LoginSuccessHandler<A, B, C> andThen(LoginSuccessHandler<? super A, ? super B, ? super C> after) {
        return (exchange, authentication) -> this.handleLoginSuccess(exchange, authentication).then(after.handleLoginSuccess(exchange, authentication));
    }

    default public LoginSuccessHandler<A, B, C> compose(LoginSuccessHandler<? super A, ? super B, ? super C> before) {
        return (exchange, authentication) -> before.handleLoginSuccess(exchange, authentication).then(this.handleLoginSuccess(exchange, authentication));
    }

    @SafeVarargs
    public static <A extends Authentication, B extends ExchangeContext, C extends Exchange<B>> LoginSuccessHandler<A, B, C> of(LoginSuccessHandler<? super A, ? super B, ? super C> ... handlers) {
        return (exchange, authentication) -> {
            Mono handlerChain = null;
            for (LoginSuccessHandler handler : handlers) {
                handlerChain = handlerChain == null ? handler.handleLoginSuccess(exchange, authentication) : handlerChain.thenEmpty(handler.handleLoginSuccess(exchange, authentication));
            }
            return handlerChain;
        };
    }
}

