/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.internal;

import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.security.SecurityException;
import io.inverno.mod.security.accesscontrol.AccessController;
import io.inverno.mod.security.accesscontrol.AccessControllerResolver;
import io.inverno.mod.security.authentication.Authentication;
import io.inverno.mod.security.authentication.AuthenticationException;
import io.inverno.mod.security.authentication.Authenticator;
import io.inverno.mod.security.authentication.Credentials;
import io.inverno.mod.security.context.SecurityContext;
import io.inverno.mod.security.http.CredentialsExtractor;
import io.inverno.mod.security.http.SecurityInterceptor;
import io.inverno.mod.security.http.context.InterceptingSecurityContext;
import io.inverno.mod.security.identity.Identity;
import io.inverno.mod.security.identity.IdentityResolver;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reactor.core.publisher.Mono;

public class GenericSecurityInterceptor<A extends Credentials, B extends Authentication, C extends Identity, D extends AccessController, E extends InterceptingSecurityContext<C, D>, F extends Exchange<E>>
implements SecurityInterceptor<A, C, D, E, F> {
    private static final Logger LOGGER = LogManager.getLogger(GenericSecurityInterceptor.class);
    private final CredentialsExtractor<? extends A> credentialsExtractor;
    private final Authenticator<? super A, ? extends B> authenticator;
    private final Optional<IdentityResolver<? super B, ? extends C>> identityResolver;
    private final Optional<AccessControllerResolver<? super B, ? extends D>> accessControllerResolver;

    public GenericSecurityInterceptor(CredentialsExtractor<? extends A> credentialsExtractor, Authenticator<? super A, ? extends B> authenticator) {
        this(credentialsExtractor, authenticator, null, null);
    }

    public GenericSecurityInterceptor(CredentialsExtractor<? extends A> credentialsExtractor, Authenticator<? super A, ? extends B> authenticator, IdentityResolver<? super B, ? extends C> identityResolver) {
        this(credentialsExtractor, authenticator, identityResolver, null);
    }

    public GenericSecurityInterceptor(CredentialsExtractor<? extends A> credentialsExtractor, Authenticator<? super A, ? extends B> authenticator, AccessControllerResolver<? super B, ? extends D> accessControllerResolver) {
        this(credentialsExtractor, authenticator, null, accessControllerResolver);
    }

    public GenericSecurityInterceptor(CredentialsExtractor<? extends A> credentialsExtractor, Authenticator<? super A, ? extends B> authenticator, IdentityResolver<? super B, ? extends C> identityResolver, AccessControllerResolver<? super B, ? extends D> accessControllerResolver) {
        this.credentialsExtractor = Objects.requireNonNull(credentialsExtractor);
        this.authenticator = Objects.requireNonNull(authenticator);
        this.identityResolver = Optional.ofNullable(identityResolver);
        this.accessControllerResolver = Optional.ofNullable(accessControllerResolver);
    }

    public Mono<? extends F> intercept(F exchange) {
        return this.credentialsExtractor.extract((Exchange<?>)exchange).switchIfEmpty(Mono.fromRunnable(() -> ((InterceptingSecurityContext)exchange.context()).setSecurityContext(SecurityContext.of((Authentication)Authentication.anonymous())))).flatMap(credentials -> this.authenticator.authenticate(credentials).switchIfEmpty(Mono.error(() -> new AuthenticationException("Unable to authenticate"))).doOnError(SecurityException.class, error -> LOGGER.debug("Failed to authenticate", (Throwable)error))).flatMap(authentication -> Mono.zip((Mono)Mono.just((Object)authentication), (Mono)this.identityResolver.filter(ign -> authentication.isAuthenticated()).map(resolver -> resolver.resolveIdentity(authentication).doOnError(SecurityException.class, error -> LOGGER.debug("Failed to resolve identity", (Throwable)error)).map(Optional::of)).orElse(Mono.just(Optional.empty())), (Mono)this.accessControllerResolver.filter(ign -> authentication.isAuthenticated()).map(resolver -> resolver.resolveAccessController(authentication).doOnError(SecurityException.class, error -> LOGGER.debug("Failed to resolve authorizations", (Throwable)error)).map(Optional::of)).orElse(Mono.just(Optional.empty())))).doOnNext(tuple3 -> ((InterceptingSecurityContext)exchange.context()).setSecurityContext(SecurityContext.of((Authentication)((Authentication)tuple3.getT1()), (Optional)((Optional)tuple3.getT2()), (Optional)((Optional)tuple3.getT3())))).onErrorResume(SecurityException.class, error -> {
            ((InterceptingSecurityContext)exchange.context()).setSecurityContext(SecurityContext.of((Authentication)Authentication.denied((SecurityException)error)));
            return Mono.empty();
        }).thenReturn(exchange);
    }
}

