/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.basic;

import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.security.authentication.LoginCredentials;
import io.inverno.mod.security.authentication.password.Password;
import io.inverno.mod.security.authentication.password.RawPassword;
import io.inverno.mod.security.http.CredentialsExtractor;
import io.inverno.mod.security.http.MalformedCredentialsException;
import java.util.Base64;
import reactor.core.publisher.Mono;

public class BasicCredentialsExtractor
implements CredentialsExtractor<LoginCredentials> {
    @Override
    public Mono<LoginCredentials> extract(Exchange<?> exchange) throws MalformedCredentialsException {
        return Mono.fromSupplier(() -> exchange.request().headers().getHeader((CharSequence)"authorization").filter(authorizationHeader -> authorizationHeader.getAuthScheme().equals("basic")).map(authorizationHeader -> {
            String[] splitCredentials = new String(Base64.getDecoder().decode(authorizationHeader.getToken())).split(":");
            switch (splitCredentials.length) {
                case 1: {
                    if (splitCredentials[0].isBlank()) {
                        return null;
                    }
                    return LoginCredentials.of((String)splitCredentials[0], (Password)new RawPassword(""));
                }
                case 2: {
                    return LoginCredentials.of((String)splitCredentials[0], (Password)new RawPassword(splitCredentials[1]));
                }
            }
            throw new MalformedCredentialsException("Invalid basic credentials");
        }).orElse(null));
    }
}

