/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.form;

import io.inverno.mod.base.net.URIs;
import io.inverno.mod.http.base.HttpException;
import io.inverno.mod.http.base.Method;
import io.inverno.mod.http.base.Status;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.ExchangeContext;
import io.inverno.mod.security.http.AuthenticationErrorInterceptor;
import reactor.core.publisher.Mono;

public class FormAuthenticationErrorInterceptor<A extends ExchangeContext, B extends ErrorExchange<A>>
extends AuthenticationErrorInterceptor<A, B> {
    public static final String DEFAULT_LOGIN_PAGE_URI = "/login";
    private final String loginUri;

    public FormAuthenticationErrorInterceptor() {
        this(DEFAULT_LOGIN_PAGE_URI);
    }

    public FormAuthenticationErrorInterceptor(String loginUri) {
        super(true);
        this.loginUri = loginUri;
    }

    public String getLoginUri() {
        return this.loginUri;
    }

    @Override
    public Mono<? extends B> intercept(B exchange) {
        if (exchange.request().getMethod().equals((Object)Method.GET)) {
            return super.intercept(exchange);
        }
        return Mono.just(exchange);
    }

    @Override
    protected void interceptUnauthorized(B exchange) throws HttpException {
        exchange.response().headers(headers -> headers.status(Status.FOUND).set((CharSequence)"location", (CharSequence)URIs.uri((String)this.loginUri, (URIs.Option[])new URIs.Option[0]).queryParameter("redirect_uri", exchange.request().getPath()).buildString(new Object[0])));
    }
}

