/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.digest;

import io.inverno.mod.security.authentication.AuthenticationException;
import io.inverno.mod.security.authentication.CredentialsMatcher;
import io.inverno.mod.security.authentication.LoginCredentials;
import io.inverno.mod.security.authentication.password.Password;
import io.inverno.mod.security.authentication.password.RawPassword;
import io.inverno.mod.security.http.digest.DigestCredentials;
import io.inverno.mod.security.http.digest.DigestPassword;
import io.inverno.mod.security.http.digest.DigestUtils;
import io.inverno.mod.security.http.digest.ExpiredNonceException;

public class DigestCredentialsMatcher<A extends LoginCredentials>
implements CredentialsMatcher<DigestCredentials, A> {
    private final String secret;

    public DigestCredentialsMatcher(String secret) {
        this.secret = secret;
    }

    public boolean matches(DigestCredentials credentials, A otherCredentials) throws AuthenticationException {
        String serverDigest;
        String hash_a1;
        if (System.nanoTime() - credentials.getNonceExpire() > 0L) {
            throw new ExpiredNonceException("Nonce has expired");
        }
        String serverNonceHash = DigestUtils.kd(credentials.getDigest(), this.secret, Long.toString(credentials.getNonceExpire()));
        if (!serverNonceHash.equals(credentials.getNonceHash())) {
            throw new AuthenticationException("Invalid nonce hash");
        }
        Password resolvedPassword = otherCredentials.getPassword();
        if (resolvedPassword instanceof RawPassword) {
            hash_a1 = DigestUtils.h(credentials.getDigest(), credentials.getUsername() + ":" + credentials.getRealm() + ":" + resolvedPassword.getValue());
        } else if (resolvedPassword instanceof DigestPassword) {
            DigestPassword resolvedDigestPassword = (DigestPassword)resolvedPassword;
            if (!((DigestPassword.Encoder)resolvedDigestPassword.getEncoder()).getAlgorithm().equals(credentials.getDigest().getAlgorithm())) {
                throw new AuthenticationException("Algorithm does not match credentials algorithm");
            }
            if (((DigestPassword.Encoder)resolvedDigestPassword.getEncoder()).getRealm().equals(credentials.getRealm())) {
                throw new AuthenticationException("Realm does not match credentials realm");
            }
            hash_a1 = resolvedPassword.getValue();
        } else {
            throw new AuthenticationException("Resolved credentials are not compatible with digest authentication scheme");
        }
        String hash_a2 = DigestUtils.h(credentials.getDigest(), credentials.getMethod() + ":" + credentials.getUri());
        if (null == credentials.getQop()) {
            serverDigest = DigestUtils.kd(credentials.getDigest(), hash_a1, credentials.getNonce() + ":" + hash_a2);
        } else {
            switch (credentials.getQop()) {
                case "auth": {
                    serverDigest = DigestUtils.kd(credentials.getDigest(), hash_a1, credentials.getNonce() + ":" + credentials.getNc() + ":" + credentials.getCnonce() + ":" + credentials.getQop() + ":" + hash_a2);
                    break;
                }
                default: {
                    throw new AuthenticationException("Unsupported qop: " + credentials.getQop());
                }
            }
        }
        return serverDigest.equals(credentials.getResponse());
    }
}

