/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.csrf;

import io.inverno.mod.base.Charsets;
import io.inverno.mod.base.converter.Convertible;
import io.inverno.mod.http.base.ForbiddenException;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.SetCookie;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeContext;
import io.inverno.mod.http.server.ExchangeInterceptor;
import io.inverno.mod.http.server.RequestBody;
import java.security.MessageDigest;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Mono;

public class CSRFDoubleSubmitCookieInterceptor<A extends ExchangeContext, B extends Exchange<A>>
implements ExchangeInterceptor<A, B> {
    public static final String DEFAULT_COOKIE_NAME = "XSRF-TOKEN";
    public static final String DEFAULT_HEADER_NAME = "X-CSRF-TOKEN";
    public static final String DEFAULT_PARAMETER_NAME = "_csrf_token";
    protected final String cookieName;
    protected final String headerName;
    protected final String parameterName;
    protected final Integer maxAge;
    protected final String domain;
    protected final String path;
    protected final boolean secure;
    protected final boolean httpOnly;

    protected CSRFDoubleSubmitCookieInterceptor(String cookieName, String headerName, String parameterName, Integer maxAge, String domain, String path, Boolean secure, Boolean httpOnly) {
        this.cookieName = StringUtils.isNotBlank((CharSequence)cookieName) ? cookieName : DEFAULT_COOKIE_NAME;
        this.headerName = StringUtils.isNotBlank((CharSequence)headerName) ? headerName : DEFAULT_HEADER_NAME;
        this.parameterName = StringUtils.isNotBlank((CharSequence)parameterName) ? parameterName : DEFAULT_PARAMETER_NAME;
        this.maxAge = maxAge;
        this.domain = domain;
        this.path = path;
        this.secure = secure != null ? secure : true;
        this.httpOnly = httpOnly != null ? httpOnly : true;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Mono<? extends B> intercept(B exchange) {
        switch (exchange.request().getMethod()) {
            case POST: 
            case PUT: 
            case PATCH: 
            case DELETE: {
                byte[] csrfCookie = exchange.request().cookies().get(this.cookieName).map(Convertible::asString).orElseThrow(() -> new ForbiddenException("Missing CSRF token cookie")).getBytes(Charsets.UTF_8);
                byte[] csrfParameter = exchange.request().headers().get((CharSequence)this.headerName).or(() -> exchange.request().queryParameters().get(this.parameterName).map(Convertible::asString)).map(value -> value.getBytes(Charsets.UTF_8)).orElse(null);
                if (csrfParameter != null) {
                    if (!MessageDigest.isEqual(csrfParameter, csrfCookie)) {
                        throw new ForbiddenException("CSRF token header does not match CSRF token cookie");
                    }
                    this.addCSRFTokenCookie(exchange);
                    return Mono.just(exchange);
                }
                if ("application/x-www-form-urlencoded".equalsIgnoreCase(exchange.request().headers().getContentType())) {
                    return ((RequestBody)exchange.request().body().orElseThrow(() -> new ForbiddenException("Missing CSRF token header/parameter"))).urlEncoded().collectMap().mapNotNull(parameters -> {
                        Parameter csrfFormParameter = (Parameter)parameters.get(this.parameterName);
                        return csrfFormParameter != null ? csrfFormParameter.asString() : null;
                    }).map(csrfFormParameter -> {
                        if (!MessageDigest.isEqual(csrfFormParameter.getBytes(Charsets.UTF_8), csrfCookie)) {
                            throw new ForbiddenException("CSRF token header does not match CSRF token cookie");
                        }
                        this.addCSRFTokenCookie(exchange);
                        return exchange;
                    }).switchIfEmpty(Mono.error(() -> new ForbiddenException("Missing CSRF token header/parameter")));
                }
                throw new ForbiddenException("Missing CSRF token header/parameter");
            }
        }
        this.addCSRFTokenCookie(exchange);
        return Mono.just(exchange);
    }

    private void addCSRFTokenCookie(B exchange) {
        exchange.response().cookies(cookies -> cookies.addCookie(cookie -> {
            cookie.name(this.cookieName).value(this.generateToken()).sameSite(SetCookie.SameSitePolicy.STRICT);
            if (this.maxAge != null) {
                cookie.maxAge(this.maxAge.intValue());
            }
            if (this.domain != null) {
                cookie.domain(this.domain);
            }
            if (this.path != null) {
                cookie.path(this.path);
            }
            if (this.secure) {
                cookie.secure(this.secure);
            }
            if (this.httpOnly) {
                cookie.httpOnly(this.httpOnly);
            }
        }));
    }

    protected String generateToken() {
        return UUID.randomUUID().toString();
    }

    public static class Builder {
        protected String cookieName;
        protected String headerName;
        protected String parameterName;
        protected Integer maxAge;
        protected String domain;
        protected String path;
        protected Boolean secure;
        protected Boolean httpOnly;

        protected Builder() {
        }

        public Builder cookieName(String cookieName) {
            this.cookieName = cookieName;
            return this;
        }

        public Builder headerName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public Builder maxAge(int maxAge) {
            this.maxAge = maxAge >= 0 ? Integer.valueOf(maxAge) : null;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public <A extends ExchangeContext, B extends Exchange<A>> CSRFDoubleSubmitCookieInterceptor<A, B> build() {
            return new CSRFDoubleSubmitCookieInterceptor(this.cookieName, this.headerName, this.parameterName, this.maxAge, this.domain, this.path, this.secure, this.httpOnly);
        }
    }
}

