/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.basic;

import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.ExchangeContext;
import io.inverno.mod.security.SecurityException;
import io.inverno.mod.security.http.HttpAuthenticationErrorInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class BasicAuthenticationErrorInterceptor<A extends ExchangeContext, B extends ErrorExchange<A>>
extends HttpAuthenticationErrorInterceptor<A, B> {
    private static final String PARAMETER_REALM = "realm";
    private static final String FORMAT_WWW_AUTHENTICATE = "basic realm=\"%s\"";
    private final String realm;

    public BasicAuthenticationErrorInterceptor(String realm) {
        if (StringUtils.isBlank((CharSequence)realm)) {
            throw new IllegalArgumentException("realm is null or empty");
        }
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    @Override
    protected String createChallenge(SecurityException cause) {
        return String.format(FORMAT_WWW_AUTHENTICATE, StringEscapeUtils.escapeJava((String)this.realm));
    }
}

