/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.login;

import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.HttpException;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeHandler;
import io.inverno.mod.http.server.Response;
import io.inverno.mod.security.SecurityException;
import io.inverno.mod.security.authentication.Authentication;
import io.inverno.mod.security.authentication.AuthenticationException;
import io.inverno.mod.security.authentication.Authenticator;
import io.inverno.mod.security.authentication.LoginCredentials;
import io.inverno.mod.security.http.CredentialsExtractor;
import io.inverno.mod.security.http.login.LoginFailureHandler;
import io.inverno.mod.security.http.login.LoginSuccessHandler;
import reactor.core.publisher.Mono;

public class LoginActionHandler<A extends LoginCredentials, B extends Authentication, C extends ExchangeContext, D extends Exchange<C>>
implements ExchangeHandler<C, D> {
    private final CredentialsExtractor<A> credentialsExtractor;
    private final Authenticator<A, B> authenticator;
    private final LoginSuccessHandler<B, C, D> loginSuccessHandler;
    private final LoginFailureHandler<C, D> loginFailureHandler;

    public LoginActionHandler(CredentialsExtractor<A> credentialsExtractor, Authenticator<A, B> authenticator) {
        this(credentialsExtractor, authenticator, null, null);
    }

    public LoginActionHandler(CredentialsExtractor<A> credentialsExtractor, Authenticator<A, B> authenticator, LoginSuccessHandler<B, C, D> loginSuccessHandler, LoginFailureHandler<C, D> loginFailureHandler) {
        this.credentialsExtractor = credentialsExtractor;
        this.authenticator = authenticator;
        this.loginSuccessHandler = loginSuccessHandler;
        this.loginFailureHandler = loginFailureHandler;
    }

    public CredentialsExtractor<A> getCredentialsExtractor() {
        return this.credentialsExtractor;
    }

    public Authenticator<A, B> getAuthenticator() {
        return this.authenticator;
    }

    public LoginSuccessHandler<B, C, D> getLoginSuccessHandler() {
        return this.loginSuccessHandler;
    }

    public LoginFailureHandler<C, D> getLoginFailureHandler() {
        return this.loginFailureHandler;
    }

    public Mono<Void> defer(D exchange) {
        Mono result = this.credentialsExtractor.extract((Exchange<?>)exchange).flatMap(arg_0 -> this.authenticator.authenticate(arg_0)).flatMap(authentication -> {
            if (authentication.isAuthenticated()) {
                if (this.loginSuccessHandler != null) {
                    return this.loginSuccessHandler.handleLoginSuccess(exchange, authentication);
                }
                return Mono.fromRunnable(() -> ((Response)exchange.response()).body().empty());
            }
            if (authentication.getCause().isPresent()) {
                throw (SecurityException)authentication.getCause().get();
            }
            throw new AuthenticationException();
        });
        if (this.loginFailureHandler != null) {
            result = result.onErrorResume(SecurityException.class, error -> this.loginFailureHandler.handleLoginFailure(exchange, (SecurityException)error));
        }
        return result;
    }

    public void handle(D exchange) throws HttpException {
        throw new UnsupportedOperationException();
    }
}

