/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.http.form;

import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.Request;
import io.inverno.mod.http.server.RequestBody;
import io.inverno.mod.security.authentication.InvalidCredentialsException;
import io.inverno.mod.security.authentication.LoginCredentials;
import io.inverno.mod.security.authentication.password.Password;
import io.inverno.mod.security.authentication.password.RawPassword;
import io.inverno.mod.security.http.CredentialsExtractor;
import io.inverno.mod.security.http.MalformedCredentialsException;
import reactor.core.publisher.Mono;

public class FormCredentialsExtractor
implements CredentialsExtractor<LoginCredentials> {
    public static final String DEFAULT_PARAMETER_USERNAME = "username";
    public static final String DEFAULT_PARAMETER_PASSWORD = "password";
    private final String usernameParameter;
    private final String passwordParameter;

    public FormCredentialsExtractor() {
        this(DEFAULT_PARAMETER_USERNAME, DEFAULT_PARAMETER_PASSWORD);
    }

    public FormCredentialsExtractor(String usernameParameter, String passwordParameter) {
        this.usernameParameter = usernameParameter;
        this.passwordParameter = passwordParameter;
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    @Override
    public Mono<LoginCredentials> extract(Exchange<?> exchange) throws MalformedCredentialsException {
        return ((RequestBody)((Request)exchange.request()).body().get()).urlEncoded().collectMap().map(parameterMap -> {
            Parameter username = (Parameter)parameterMap.get(this.usernameParameter);
            if (username == null) {
                throw new InvalidCredentialsException("Missing username");
            }
            Parameter password = (Parameter)parameterMap.get(this.passwordParameter);
            if (password == null) {
                throw new InvalidCredentialsException("Missing password");
            }
            return LoginCredentials.of((String)((String)username.getValue()), (Password)new RawPassword((String)password.getValue()));
        });
    }
}

