/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.InboundSetCookies;
import io.inverno.mod.http.base.OutboundResponseHeaders;
import io.inverno.mod.http.base.OutboundSetCookies;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.Status;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.GenericParameter;
import io.inverno.mod.http.server.internal.GenericResponseCookies;
import io.inverno.mod.http.server.internal.InternalResponseHeaders;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

class Http2ResponseHeaders
implements InternalResponseHeaders {
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final Http2Headers underlyingHeaders;
    private GenericResponseCookies responseCookies;
    private boolean written;

    public Http2ResponseHeaders(HeaderService headerService, ObjectConverter<String> parameterConverter) {
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.underlyingHeaders = new DefaultHttp2Headers();
        this.underlyingHeaders.set((Object)Http2Headers.PseudoHeaderName.STATUS.value(), (Object)"200");
    }

    Http2Headers getUnderlyingHeaders() {
        return this.underlyingHeaders;
    }

    @Override
    public void setWritten(boolean written) {
        this.written = written;
    }

    public boolean isWritten() {
        return this.written;
    }

    public Http2ResponseHeaders status(Status status) {
        return this.status(status.getCode());
    }

    public Http2ResponseHeaders status(int status) {
        this.underlyingHeaders.setInt((Object)Http2Headers.PseudoHeaderName.STATUS.value(), status);
        return this;
    }

    public Status getStatus() throws IllegalArgumentException {
        return Status.valueOf((int)this.getStatusCode());
    }

    public int getStatusCode() {
        return this.underlyingHeaders.getInt((Object)Http2Headers.PseudoHeaderName.STATUS.value());
    }

    public Http2ResponseHeaders contentType(String contentType) {
        this.underlyingHeaders.set((Object)"content-type", (Object)contentType);
        return this;
    }

    public String getContentType() {
        return ((CharSequence)this.underlyingHeaders.get((Object)"content-type")).toString();
    }

    public Headers.ContentType getContentTypeHeader() {
        return this.getHeader("content-type").orElse(null);
    }

    @Override
    public CharSequence getContentTypeCharSequence() {
        return (CharSequence)this.underlyingHeaders.get((Object)"content-type");
    }

    public Http2ResponseHeaders contentLength(long contentLength) {
        this.underlyingHeaders.setLong((Object)"content-length", contentLength);
        return this;
    }

    public Long getContentLength() {
        return this.underlyingHeaders.getLong((Object)"content-length");
    }

    public OutboundResponseHeaders cookies(Consumer<OutboundSetCookies> cookiesConfigurer) {
        if (cookiesConfigurer != null) {
            cookiesConfigurer.accept((OutboundSetCookies)this.cookies());
        }
        return this;
    }

    public InboundSetCookies cookies() {
        if (this.responseCookies == null) {
            this.responseCookies = new GenericResponseCookies(this.headerService, this, this.parameterConverter);
        }
        return this.responseCookies;
    }

    public Http2ResponseHeaders add(CharSequence name, CharSequence value) {
        this.underlyingHeaders.add((Object)name, (Object)value);
        return this;
    }

    public Http2ResponseHeaders add(Header ... headers) {
        for (Header header : headers) {
            this.underlyingHeaders.add((Object)header.getHeaderName(), (Object)this.headerService.encodeValue(header));
        }
        return this;
    }

    public Http2ResponseHeaders set(CharSequence name, CharSequence value) {
        this.underlyingHeaders.set((Object)name, (Object)value);
        return this;
    }

    public Http2ResponseHeaders set(Header ... headers) {
        for (Header header : headers) {
            this.underlyingHeaders.set((Object)header.getHeaderName(), (Object)this.headerService.encodeValue(header));
        }
        return this;
    }

    public Http2ResponseHeaders remove(CharSequence ... names) {
        for (CharSequence name : names) {
            this.underlyingHeaders.remove((Object)name);
        }
        return this;
    }

    public boolean contains(CharSequence name) {
        return this.underlyingHeaders.contains((Object)name);
    }

    public boolean contains(CharSequence name, CharSequence value) {
        return this.underlyingHeaders.contains(name, value, true);
    }

    public Set<String> getNames() {
        return this.underlyingHeaders.names().stream().map(CharSequence::toString).collect(Collectors.toSet());
    }

    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable((CharSequence)this.underlyingHeaders.get((Object)name)).map(Object::toString);
    }

    public List<String> getAll(CharSequence name) {
        return this.underlyingHeaders.getAll((Object)name).stream().map(CharSequence::toString).collect(Collectors.toList());
    }

    public List<Map.Entry<String, String>> getAll() {
        LinkedList<Map.Entry<String, String>> result = new LinkedList<Map.Entry<String, String>>();
        this.underlyingHeaders.forEach(e -> result.add(Map.entry(((CharSequence)e.getKey()).toString(), ((CharSequence)e.getValue()).toString())));
        return result;
    }

    public <T extends Header> Optional<T> getHeader(CharSequence name) {
        return this.get(name).map(value -> this.headerService.decode(name.toString(), value));
    }

    public <T extends Header> List<T> getAllHeader(CharSequence name) {
        return this.underlyingHeaders.getAll((Object)name).stream().map(value -> this.headerService.decode(name.toString(), value.toString())).collect(Collectors.toList());
    }

    public List<Header> getAllHeader() {
        LinkedList<Header> result = new LinkedList<Header>();
        this.underlyingHeaders.forEach(e -> result.add(this.headerService.decode(((CharSequence)e.getKey()).toString(), ((CharSequence)e.getValue()).toString())));
        return result;
    }

    public Optional<Parameter> getParameter(CharSequence name) {
        return this.get(name).map(value -> new GenericParameter(name.toString(), value, this.parameterConverter));
    }

    public List<Parameter> getAllParameter(CharSequence name) {
        return this.underlyingHeaders.getAll((Object)name).stream().map(value -> new GenericParameter(name.toString(), value.toString(), this.parameterConverter)).collect(Collectors.toList());
    }

    public List<Parameter> getAllParameter() {
        LinkedList<Parameter> result = new LinkedList<Parameter>();
        this.underlyingHeaders.forEach(e -> result.add((Parameter)new GenericParameter(((CharSequence)e.getKey()).toString(), ((CharSequence)e.getValue()).toString(), this.parameterConverter)));
        return result;
    }

    @Override
    public CharSequence getCharSequence(CharSequence name) {
        return (CharSequence)this.underlyingHeaders.get((Object)name);
    }

    @Override
    public List<CharSequence> getAllCharSequence(CharSequence name) {
        return this.underlyingHeaders.getAll((Object)name);
    }

    @Override
    public List<Map.Entry<CharSequence, CharSequence>> getAllCharSequence() {
        LinkedList<Map.Entry<CharSequence, CharSequence>> result = new LinkedList<Map.Entry<CharSequence, CharSequence>>();
        this.underlyingHeaders.forEach(e -> result.add(Map.entry((CharSequence)e.getKey(), (CharSequence)e.getValue())));
        return result;
    }
}

