/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.OutboundHeaders;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.Response;
import io.inverno.mod.http.server.internal.AbstractResponse;
import io.inverno.mod.http.server.internal.GenericResponseBody;
import io.inverno.mod.http.server.internal.http2.Http2ResponseHeaders;
import io.inverno.mod.http.server.internal.http2.Http2ResponseTrailers;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Stream;

class Http2Response
extends AbstractResponse {
    private final Http2Stream stream;
    private final Http2ConnectionEncoder encoder;
    private final ObjectConverter<String> parameterConverter;

    public Http2Response(ChannelHandlerContext context, Http2Stream stream, Http2ConnectionEncoder encoder, HeaderService headerService, ObjectConverter<String> parameterConverter) {
        super(context, headerService, new Http2ResponseHeaders(headerService, parameterConverter));
        this.stream = stream;
        this.encoder = encoder;
        this.parameterConverter = parameterConverter;
        this.responseBody = new GenericResponseBody(this);
    }

    @Override
    public Http2ResponseHeaders headers() {
        return (Http2ResponseHeaders)this.responseHeaders;
    }

    @Override
    protected OutboundHeaders<?> createTrailers() {
        return new Http2ResponseTrailers(this.headerService, this.parameterConverter);
    }

    public Http2ResponseTrailers trailers() {
        return (Http2ResponseTrailers)super.trailers();
    }

    @Override
    public Response sendContinue() {
        if (this.isHeadersWritten()) {
            throw new IllegalStateException("Headers already written");
        }
        this.encoder.writeHeaders(this.context, this.stream.id(), new DefaultHttp2Headers().status((CharSequence)"100"), 0, false, this.context.voidPromise());
        return this;
    }
}

