/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.HttpVersion;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.ServerController;
import io.inverno.mod.http.server.internal.AbstractExchange;
import io.inverno.mod.http.server.internal.GenericErrorExchange;
import io.inverno.mod.http.server.internal.http2.Http2Request;
import io.inverno.mod.http.server.internal.http2.Http2RequestHeaders;
import io.inverno.mod.http.server.internal.http2.Http2Response;
import io.inverno.mod.http.server.internal.http2.Http2ResponseHeaders;
import io.inverno.mod.http.server.internal.http2.Http2ResponseTrailers;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.inverno.mod.http.server.ws.WebSocket;
import io.inverno.mod.http.server.ws.WebSocketExchange;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import java.util.Optional;
import reactor.core.publisher.Mono;

class Http2Exchange
extends AbstractExchange {
    private final Http2Stream stream;
    private final Http2ConnectionEncoder encoder;
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;

    public Http2Exchange(ChannelHandlerContext context, Http2Stream stream, Http2Headers httpHeaders, Http2ConnectionEncoder encoder, HeaderService headerService, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder, ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller) {
        super(context, controller, new Http2Request(context, new Http2RequestHeaders(httpHeaders, headerService, parameterConverter), parameterConverter, urlEncodedBodyDecoder, multipartBodyDecoder), new Http2Response(context, stream, encoder, headerService, parameterConverter));
        this.stream = stream;
        this.encoder = encoder;
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
    }

    public HttpVersion getProtocol() {
        return HttpVersion.HTTP_2_0;
    }

    @Override
    public Optional<? extends WebSocket<ExchangeContext, ? extends WebSocketExchange<ExchangeContext>>> webSocket(String ... subProtocols) {
        return Optional.empty();
    }

    public void setContentEncoding(String contentEncoding) {
        if (contentEncoding != null) {
            this.response.headers().set("content-encoding", contentEncoding);
        }
    }

    @Override
    protected ErrorExchange<ExchangeContext> createErrorExchange(Throwable error) {
        return new GenericErrorExchange(this, new Http2Response(this.context, this.stream, this.encoder, this.headerService, this.parameterConverter), error, (Mono<Void>)this.finalizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onNextMany(ByteBuf value, ChannelPromise nextPromise) {
        try {
            Http2ResponseHeaders headers = (Http2ResponseHeaders)this.response.headers();
            if (!headers.isWritten()) {
                this.encoder.writeHeaders(this.context, this.stream.id(), headers.getUnderlyingHeaders(), 0, false, this.context.voidPromise());
                headers.setWritten(true);
            }
            this.encoder.writeData(this.context, this.stream.id(), value, 0, false, nextPromise);
            this.context.channel().flush();
        }
        finally {
            this.handler.exchangeNext(this.context, value);
        }
    }

    @Override
    protected void onCompleteWithError(Throwable throwable) {
        ChannelPromise finalizePromise = this.context.newPromise();
        this.finalizeExchange(finalizePromise, () -> this.handler.exchangeError(this.context, throwable));
        finalizePromise.tryFailure(throwable);
    }

    @Override
    protected void onCompleteEmpty() {
        Http2ResponseHeaders headers = (Http2ResponseHeaders)this.response.headers();
        Http2ResponseTrailers trailers = (Http2ResponseTrailers)this.response.trailers();
        if (trailers == null) {
            ChannelPromise finalizePromise = this.context.newPromise();
            this.encoder.writeHeaders(this.context, this.stream.id(), headers.getUnderlyingHeaders(), 0, true, finalizePromise);
            headers.setWritten(true);
            this.finalizeExchange(finalizePromise, () -> this.handler.exchangeComplete(this.context));
        } else {
            this.encoder.writeHeaders(this.context, this.stream.id(), headers.getUnderlyingHeaders(), 0, false, this.context.voidPromise());
            headers.setWritten(true);
            ChannelPromise finalizePromise = this.context.newPromise();
            this.encoder.writeHeaders(this.context, this.stream.id(), trailers.getUnderlyingTrailers(), 0, true, finalizePromise);
            trailers.setWritten(true);
            this.finalizeExchange(finalizePromise, () -> this.handler.exchangeComplete(this.context));
        }
        this.context.channel().flush();
    }

    @Override
    protected void onCompleteSingle(ByteBuf value) {
        Http2ResponseHeaders headers = (Http2ResponseHeaders)this.response.headers();
        this.encoder.writeHeaders(this.context, this.stream.id(), headers.getUnderlyingHeaders(), 0, false, this.context.voidPromise());
        headers.setWritten(true);
        Http2ResponseTrailers trailers = (Http2ResponseTrailers)this.response.trailers();
        if (trailers == null) {
            ChannelPromise finalizePromise = this.context.newPromise();
            this.encoder.writeData(this.context, this.stream.id(), value, 0, true, finalizePromise);
            this.handler.exchangeNext(this.context, value);
            this.finalizeExchange(finalizePromise, () -> this.handler.exchangeComplete(this.context));
        } else {
            this.encoder.writeData(this.context, this.stream.id(), value, 0, false, this.context.voidPromise());
            this.handler.exchangeNext(this.context, value);
            ChannelPromise finalizePromise = this.context.newPromise();
            this.encoder.writeHeaders(this.context, this.stream.id(), trailers.getUnderlyingTrailers(), 0, true, finalizePromise);
            trailers.setWritten(true);
            this.finalizeExchange(finalizePromise, () -> this.handler.exchangeComplete(this.context));
        }
        this.context.channel().flush();
    }

    @Override
    protected void onCompleteMany() {
        Http2ResponseHeaders headers = (Http2ResponseHeaders)this.response.headers();
        Http2ResponseTrailers trailers = (Http2ResponseTrailers)this.response.trailers();
        if (!headers.isWritten()) {
            if (trailers == null) {
                ChannelPromise finalizePromise = this.context.newPromise();
                this.encoder.writeHeaders(this.context, this.stream.id(), headers.getUnderlyingHeaders(), 0, true, finalizePromise);
                headers.setWritten(true);
                this.finalizeExchange(finalizePromise, () -> this.handler.exchangeComplete(this.context));
            } else {
                this.encoder.writeHeaders(this.context, this.stream.id(), headers.getUnderlyingHeaders(), 0, false, this.context.voidPromise());
                headers.setWritten(true);
                ChannelPromise finalizePromise = this.context.newPromise();
                this.encoder.writeHeaders(this.context, this.stream.id(), trailers.getUnderlyingTrailers(), 0, true, finalizePromise);
                trailers.setWritten(true);
                this.finalizeExchange(finalizePromise, () -> this.handler.exchangeComplete(this.context));
            }
        } else if (trailers != null) {
            ChannelPromise finalizePromise = this.context.newPromise();
            this.encoder.writeHeaders(this.context, this.stream.id(), trailers.getUnderlyingTrailers(), 0, true, finalizePromise);
            trailers.setWritten(true);
            this.finalizeExchange(finalizePromise, () -> this.handler.exchangeComplete(this.context));
        } else {
            ChannelPromise finalizePromise = this.context.newPromise();
            this.encoder.writeData(this.context, this.stream.id(), Unpooled.EMPTY_BUFFER, 0, true, finalizePromise);
            this.finalizeExchange(finalizePromise, () -> this.handler.exchangeComplete(this.context));
        }
        this.context.channel().flush();
    }

    @Override
    protected void onReset(long code) {
        this.handler.exchangeReset(this.context, code);
    }
}

