/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.HttpVersion;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.HttpServerException;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.ResetStreamException;
import io.inverno.mod.http.server.ServerController;
import io.inverno.mod.http.server.internal.AbstractExchange;
import io.inverno.mod.http.server.internal.HttpConnection;
import io.inverno.mod.http.server.internal.http2.Http2ContentEncodingResolver;
import io.inverno.mod.http.server.internal.http2.Http2Exchange;
import io.inverno.mod.http.server.internal.http2.Http2RequestHeaders;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.concurrent.Executor;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public class Http2Connection
extends Http2ConnectionHandler
implements HttpConnection,
Http2FrameListener,
Http2Connection.Listener {
    private final HttpServerConfiguration configuration;
    private final ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller;
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final MultipartDecoder<Parameter> urlEncodedBodyDecoder;
    private final MultipartDecoder<Part> multipartBodyDecoder;
    private final Http2ContentEncodingResolver contentEncodingResolver;
    private final IntObjectMap<Http2Exchange> serverStreams;
    protected ChannelHandlerContext context;
    protected boolean tls;
    private boolean closing;
    private boolean closed;

    public Http2Connection(HttpServerConfiguration configuration, Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller, HeaderService headerService, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder, Http2ContentEncodingResolver contentEncodingResolver) {
        super(decoder, encoder, initialSettings);
        this.configuration = configuration;
        this.controller = controller;
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.urlEncodedBodyDecoder = urlEncodedBodyDecoder;
        this.multipartBodyDecoder = multipartBodyDecoder;
        this.contentEncodingResolver = contentEncodingResolver;
        this.serverStreams = new IntObjectHashMap();
        this.connection().addListener((Http2Connection.Listener)this);
    }

    @Override
    public boolean isTls() {
        return this.tls;
    }

    @Override
    public HttpVersion getProtocol() {
        return HttpVersion.HTTP_2_0;
    }

    @Override
    public Mono<Void> shutdown() {
        if (this.closing || this.closed) {
            return Mono.empty();
        }
        return Mono.create(sink -> {
            if (!this.closed && !this.closing) {
                this.closing = true;
                this.goAway(this.context, this.connection().remote().lastStreamCreated(), Http2Error.NO_ERROR.code(), Unpooled.EMPTY_BUFFER, this.context.voidPromise());
                this.flush(this.context);
                this.context.close().addListener(future -> {
                    if (future.isSuccess()) {
                        sink.success();
                    } else {
                        sink.error(future.cause());
                    }
                });
            } else {
                sink.success();
            }
        }).subscribeOn(Schedulers.fromExecutor((Executor)this.context.executor()));
    }

    @Override
    public Mono<Void> shutdownGracefully() {
        if (this.closing || this.closed) {
            return Mono.empty();
        }
        return Mono.create(sink -> {
            if (!this.closed && !this.closing) {
                this.closing = true;
                ChannelPromise closePromise = this.context.newPromise().addListener(future -> {
                    if (future.isSuccess()) {
                        sink.success();
                    } else {
                        sink.error(future.cause());
                    }
                });
                try {
                    this.close(this.context, closePromise);
                }
                catch (Exception e) {
                    sink.error((Throwable)e);
                }
            } else {
                sink.success();
            }
        }).subscribeOn(Schedulers.fromExecutor((Executor)this.context.executor()));
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            HttpServerUpgradeHandler.UpgradeEvent upgradeEvent = (HttpServerUpgradeHandler.UpgradeEvent)evt;
            FullHttpRequest request = upgradeEvent.upgradeRequest();
            String host = request.headers().get("host");
            request.headers().remove("http2-settings").remove("host");
            DefaultHttp2Headers headers = new DefaultHttp2Headers();
            headers.method((CharSequence)request.method().name()).path((CharSequence)request.uri()).scheme((CharSequence)"http");
            if (host != null) {
                headers.authority((CharSequence)host);
            }
            request.headers().forEach(header -> headers.add((Object)((String)header.getKey()).toLowerCase(), (Object)((CharSequence)header.getValue())));
            boolean endStream = request.content() == null || !request.content().isReadable();
            this.onHeadersRead(ctx, 1, (Http2Headers)headers, 0, endStream);
            if (!endStream) {
                this.onDataRead(ctx, 1, request.content(), 0, true);
            }
        }
        super.userEventTriggered(ctx, evt);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.context = ctx;
        this.tls = this.context.pipeline().get(SslHandler.class) != null;
        super.handlerAdded(ctx);
    }

    public void onError(ChannelHandlerContext ctx, boolean outbound, Throwable cause) {
        super.onError(ctx, outbound, cause);
    }

    protected void onStreamError(ChannelHandlerContext ctx, boolean outbound, Throwable cause, Http2Exception.StreamException http2Ex) {
        super.onStreamError(ctx, outbound, cause, http2Ex);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.shutdown().subscribe();
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        int processed = data.readableBytes() + padding;
        Http2Exchange serverStream = (Http2Exchange)this.serverStreams.get(streamId);
        if (serverStream != null) {
            if (!serverStream.isDisposed()) {
                serverStream.request().data().ifPresent(sink -> {
                    data.retain();
                    if (sink.tryEmitNext((Object)data) != Sinks.EmitResult.OK) {
                        data.release();
                    }
                });
                if (endOfStream) {
                    serverStream.request().data().ifPresent(sink -> sink.tryEmitComplete());
                }
            }
        } else {
            throw new IllegalStateException("Unable to push data to unmanaged stream " + streamId);
        }
        return processed;
    }

    public void onHeadersRead(ChannelHandlerContext ctx, final int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        Http2Exchange exchange = (Http2Exchange)this.serverStreams.get(streamId);
        if (exchange == null) {
            final Http2Exchange streamExchange = new Http2Exchange(ctx, this.connection().stream(streamId), headers, this.encoder(), this.headerService, this.parameterConverter, this.urlEncodedBodyDecoder, this.multipartBodyDecoder, this.controller);
            if (this.configuration.compression_enabled()) {
                String acceptEncoding;
                String string = acceptEncoding = headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING) != null ? ((CharSequence)headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING)).toString() : null;
                if (acceptEncoding != null) {
                    streamExchange.setContentEncoding(this.contentEncodingResolver.resolve(acceptEncoding));
                }
            }
            this.serverStreams.put(streamId, (Object)streamExchange);
            if (endOfStream) {
                streamExchange.request().data().ifPresent(sink -> sink.tryEmitComplete());
            }
            streamExchange.start(new AbstractExchange.Handler(){

                @Override
                public void exchangeStart(ChannelHandlerContext ctx, AbstractExchange exchange) {
                }

                @Override
                public void exchangeError(ChannelHandlerContext ctx, Throwable t) {
                    streamExchange.dispose(t);
                    Http2Connection.this.resetStream(ctx, streamId, Http2Error.INTERNAL_ERROR.code(), ctx.voidPromise());
                    Http2Connection.this.flush(ctx);
                }

                @Override
                public void exchangeComplete(ChannelHandlerContext ctx) {
                    streamExchange.dispose();
                }

                @Override
                public void exchangeReset(ChannelHandlerContext ctx, long code) {
                    streamExchange.dispose();
                    Http2Connection.this.resetStream(ctx, streamId, code, ctx.voidPromise());
                    Http2Connection.this.flush(ctx);
                }
            });
        } else {
            ((Http2RequestHeaders)exchange.request().headers()).getUnderlyingHeaders().add((Headers)headers);
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
    }

    public ChannelFuture resetStream(ChannelHandlerContext ctx, int streamId, long errorCode, ChannelPromise promise) {
        return super.resetStream(ctx, streamId, errorCode, promise);
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        Http2Exchange serverStream = (Http2Exchange)this.serverStreams.remove(streamId);
        if (serverStream != null) {
            serverStream.dispose(new ResetStreamException(errorCode, "Stream " + streamId + " was reset (" + errorCode + ")"));
        }
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
        if (this.configuration.decompression_enabled()) {
            this.decoder().frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener(this.decoder().connection(), (Http2FrameListener)this));
        } else {
            this.decoder().frameListener((Http2FrameListener)this);
        }
    }

    public void onPingRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
    }

    public void onPingAckRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
    }

    public void onStreamAdded(Http2Stream stream) {
    }

    public void onStreamActive(Http2Stream stream) {
    }

    public void onStreamHalfClosed(Http2Stream stream) {
    }

    public void onStreamClosed(Http2Stream stream) {
        Http2Exchange serverStream = (Http2Exchange)this.serverStreams.remove(stream.id());
        if (serverStream != null) {
            HttpServerException cause = new HttpServerException("Stream " + stream.id() + " was closed");
            serverStream.dispose(cause);
            ChannelPromise errorPromise = this.context.newPromise();
            serverStream.finalizeExchange(errorPromise, null);
            errorPromise.tryFailure((Throwable)cause);
        }
    }

    public void onStreamRemoved(Http2Stream stream) {
    }

    public void onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        this.shutdownGracefully().subscribe();
    }
}

