/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.Charsets;
import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.Method;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.Status;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.netty.FlatFullHttpResponse;
import io.inverno.mod.http.base.internal.netty.FlatHttpResponse;
import io.inverno.mod.http.base.internal.netty.FlatLastHttpContent;
import io.inverno.mod.http.base.internal.netty.LinkedHttpHeaders;
import io.inverno.mod.http.base.internal.ws.GenericWebSocketFrame;
import io.inverno.mod.http.base.internal.ws.GenericWebSocketMessage;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.ServerController;
import io.inverno.mod.http.server.internal.AbstractExchange;
import io.inverno.mod.http.server.internal.GenericErrorExchange;
import io.inverno.mod.http.server.internal.http1x.Http1xConnectionEncoder;
import io.inverno.mod.http.server.internal.http1x.Http1xRequest;
import io.inverno.mod.http.server.internal.http1x.Http1xRequestHeaders;
import io.inverno.mod.http.server.internal.http1x.Http1xResponse;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseHeaders;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseTrailers;
import io.inverno.mod.http.server.internal.http1x.Http1xWebSocket;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.inverno.mod.http.server.ws.WebSocket;
import io.inverno.mod.http.server.ws.WebSocketExchange;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Mono;

class Http1xExchange
extends AbstractExchange {
    private final HttpServerConfiguration configuration;
    private final Http1xConnectionEncoder encoder;
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final GenericWebSocketFrame.GenericFactory webSocketFrameFactory;
    private final GenericWebSocketMessage.GenericFactory webSocketMessageFactory;
    private boolean manageChunked;
    private Charset charset;
    final HttpVersion version;
    Http1xExchange next;
    boolean keepAlive;
    boolean acceptTrailers;
    private Http1xWebSocket webSocket;

    public Http1xExchange(HttpServerConfiguration configuration, ChannelHandlerContext context, HttpVersion version, HttpRequest httpRequest, Http1xConnectionEncoder encoder, HeaderService headerService, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder, ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller, GenericWebSocketFrame.GenericFactory webSocketFrameFactory, GenericWebSocketMessage.GenericFactory webSocketMessageFactory) {
        super(context, controller, new Http1xRequest(context, httpRequest, new Http1xRequestHeaders(httpRequest, headerService, parameterConverter), parameterConverter, urlEncodedBodyDecoder, multipartBodyDecoder), new Http1xResponse(version, context, headerService, parameterConverter));
        this.configuration = configuration;
        this.encoder = encoder;
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.version = version;
        HttpHeaders headers = httpRequest.headers();
        this.keepAlive = !headers.containsValue((CharSequence)"connection", (CharSequence)"close", true) && (this.version.isKeepAliveDefault() || headers.containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.KEEP_ALIVE, true));
        String te = httpRequest.headers().get("te");
        this.acceptTrailers = te != null && te.contains("trailers");
        this.webSocketFrameFactory = webSocketFrameFactory;
        this.webSocketMessageFactory = webSocketMessageFactory;
    }

    public io.inverno.mod.http.base.HttpVersion getProtocol() {
        return this.version == HttpVersion.HTTP_1_0 ? io.inverno.mod.http.base.HttpVersion.HTTP_1_0 : io.inverno.mod.http.base.HttpVersion.HTTP_1_1;
    }

    @Override
    public Optional<? extends WebSocket<ExchangeContext, ? extends WebSocketExchange<ExchangeContext>>> webSocket(String ... subProtocols) {
        this.webSocket = new Http1xWebSocket(this.configuration, this.context, this, this.webSocketFrameFactory, this.webSocketMessageFactory, subProtocols);
        return Optional.of(this.webSocket);
    }

    @Override
    protected AbstractExchange.ServerControllerSubscriber createServerControllerSubscriber() {
        return new Http1xServerControllerSubscriber();
    }

    public void dispose(boolean deep) {
        this.dispose(null);
    }

    public void dispose(Throwable error, boolean deep) {
        super.dispose(error);
        if (deep && this.next != null) {
            this.next.dispose(error, deep);
        }
    }

    @Override
    protected ErrorExchange<ExchangeContext> createErrorExchange(Throwable error) {
        return new GenericErrorExchange(this, new Http1xResponse(this.version, this.context, this.headerService, this.parameterConverter), error, (Mono<Void>)this.finalizer);
    }

    private Charset getCharset() {
        if (this.response.isHeadersWritten()) {
            return this.response().headers().getHeader("content-type").map(Headers.ContentType::getCharset).orElse(Charsets.DEFAULT);
        }
        if (this.charset == null) {
            this.charset = this.response().headers().getHeader("content-type").map(Headers.ContentType::getCharset).orElse(Charsets.DEFAULT);
        }
        return this.charset;
    }

    private void preProcessResponseInternals(Http1xResponseHeaders headers, Http1xResponseTrailers trailers) {
        if (!this.keepAlive) {
            headers.set((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE);
        }
        if (headers.getStatusCode() == Status.NOT_MODIFIED.getCode()) {
            headers.remove(new CharSequence[]{HttpHeaderNames.TRANSFER_ENCODING});
            headers.remove(new CharSequence[]{HttpHeaderNames.CONTENT_LENGTH});
            this.acceptTrailers = false;
        } else if (headers.getContentLength() != null) {
            if (headers.isChunkedTransferEncoding()) {
                headers.remove(new CharSequence[]{HttpHeaderNames.CONTENT_LENGTH});
            } else {
                this.acceptTrailers = false;
            }
        } else if (!headers.isChunkedTransferEncoding()) {
            headers.add("transfer-encoding", "chunked");
            headers.get("content-type").ifPresent(contentType -> {
                this.manageChunked = contentType.regionMatches(true, 0, "text/event-stream", 0, "text/event-stream".length());
            });
        } else {
            this.acceptTrailers = false;
        }
        if (this.acceptTrailers && trailers != null) {
            headers.set("trailer", trailers.getNames().stream().collect(Collectors.joining(", ")));
        }
    }

    private HttpResponse createHttpResponse(Http1xResponseHeaders headers, Http1xResponseTrailers trailers) {
        this.preProcessResponseInternals(headers, trailers);
        HttpResponseStatus status = HttpResponseStatus.valueOf((int)headers.getStatusCode());
        LinkedHttpHeaders httpHeaders = headers.getUnderlyingHeaders();
        return new FlatHttpResponse(this.version, status, (HttpHeaders)httpHeaders);
    }

    private HttpResponse createFullHttpResponse(Http1xResponseHeaders headers, ByteBuf content, Http1xResponseTrailers trailers) {
        this.preProcessResponseInternals(headers, trailers);
        HttpResponseStatus status = HttpResponseStatus.valueOf((int)headers.getStatusCode());
        LinkedHttpHeaders httpHeaders = headers.getUnderlyingHeaders();
        if (this.acceptTrailers && trailers != null) {
            return new FlatFullHttpResponse(this.version, status, (HttpHeaders)httpHeaders, content, (HttpHeaders)trailers.getUnderlyingTrailers());
        }
        return new FlatFullHttpResponse(this.version, status, (HttpHeaders)httpHeaders, content, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onNextMany(ByteBuf value, ChannelPromise nextPromise) {
        try {
            Http1xResponseHeaders headers = (Http1xResponseHeaders)this.response.headers();
            if (!headers.isWritten()) {
                this.encoder.writeFrame(this.context, this.createHttpResponse(headers, (Http1xResponseTrailers)this.response.trailers()), nextPromise);
                headers.setWritten(true);
            }
            if (this.manageChunked) {
                ByteBuf chunked_header = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)(Integer.toHexString(value.readableBytes()) + "\r\n"), (Charset)Charsets.orDefault((Charset)this.getCharset())));
                ByteBuf chunked_trailer = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)Charsets.orDefault((Charset)this.getCharset())));
                this.encoder.writeFrame(this.context, new DefaultHttpContent(Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{chunked_header, value, chunked_trailer})), nextPromise);
            } else {
                this.encoder.writeFrame(this.context, new DefaultHttpContent(value), nextPromise);
            }
        }
        finally {
            this.handler.exchangeNext(this.context, value);
        }
    }

    @Override
    protected void onCompleteWithError(Throwable throwable) {
        this.handler.exchangeError(this.context, throwable);
    }

    @Override
    protected void onCompleteEmpty() {
        Http1xResponse http1xResponse = (Http1xResponse)this.response;
        Http1xResponseHeaders headers = http1xResponse.headers();
        if (this.request.getMethod().equals((Object)Method.HEAD)) {
            if (headers.getContentLength() == null && !headers.contains("transfer-encoding")) {
                headers.set("transfer-encoding", "chunked");
            }
            ChannelPromise finalizePromise = this.context.newPromise();
            this.encoder.writeFrame(this.context, this.createFullHttpResponse(headers, Unpooled.buffer((int)0), (Http1xResponseTrailers)this.response.trailers()), finalizePromise);
            headers.setWritten(true);
            this.finalizeExchange(finalizePromise, () -> this.handler.exchangeComplete(this.context));
        } else {
            Publisher<FileRegion> fileRegionData = http1xResponse.body().getFileRegionData();
            if (fileRegionData == null) {
                ChannelPromise finalizePromise = this.context.newPromise();
                this.encoder.writeFrame(this.context, this.createFullHttpResponse(headers, Unpooled.buffer((int)0), (Http1xResponseTrailers)this.response.trailers()), finalizePromise);
                headers.setWritten(true);
                this.finalizeExchange(finalizePromise, () -> this.handler.exchangeComplete(this.context));
            } else {
                this.encoder.writeFrame(this.context, this.createHttpResponse(headers, http1xResponse.trailers()), this.context.voidPromise());
                headers.setWritten(true);
                FileRegionDataSubscriber fileRegionSubscriber = new FileRegionDataSubscriber();
                this.subscriber = fileRegionSubscriber;
                fileRegionData.subscribe((Subscriber)fileRegionSubscriber);
            }
        }
    }

    @Override
    protected void onCompleteSingle(ByteBuf value) {
        Http1xResponseHeaders headers = (Http1xResponseHeaders)this.response.headers();
        ChannelPromise finalizePromise = this.context.newPromise();
        this.encoder.writeFrame(this.context, this.createFullHttpResponse(headers, value, (Http1xResponseTrailers)this.response.trailers()), finalizePromise);
        headers.setWritten(true);
        this.handler.exchangeNext(this.context, value);
        this.finalizeExchange(finalizePromise, () -> this.handler.exchangeComplete(this.context));
    }

    @Override
    protected void onCompleteMany() {
        Http1xResponseTrailers responseTrailers = (Http1xResponseTrailers)this.response.trailers();
        ChannelPromise finalizePromise = this.context.newPromise();
        if (this.acceptTrailers && responseTrailers != null) {
            this.encoder.writeFrame(this.context, new FlatLastHttpContent(Unpooled.EMPTY_BUFFER, (HttpHeaders)responseTrailers.getUnderlyingTrailers()), finalizePromise);
            responseTrailers.setWritten(true);
        } else {
            this.encoder.writeFrame(this.context, LastHttpContent.EMPTY_LAST_CONTENT, finalizePromise);
        }
        this.finalizeExchange(finalizePromise, () -> this.handler.exchangeComplete(this.context));
    }

    @Override
    protected void onReset(long code) {
        Http1xResponseHeaders headers = (Http1xResponseHeaders)this.response.headers();
        if (headers.isWritten()) {
            this.handler.exchangeReset(this.context, code);
        } else {
            headers.status(Status.NO_CONTENT);
            ChannelPromise finalizePromise = this.context.newPromise();
            this.encoder.writeFrame(this.context, this.createFullHttpResponse(headers, Unpooled.buffer((int)0), (Http1xResponseTrailers)this.response.trailers()), finalizePromise);
            headers.setWritten(true);
            this.finalizeExchange(finalizePromise, () -> this.handler.exchangeComplete(this.context));
        }
    }

    protected class Http1xServerControllerSubscriber
    extends AbstractExchange.ServerControllerSubscriber {
        protected Http1xServerControllerSubscriber() {
        }

        @Override
        protected void hookOnError(Throwable t) {
            super.hookOnError(t);
        }

        @Override
        protected void hookOnComplete() {
            if (Http1xExchange.this.webSocket != null) {
                Http1xExchange.this.webSocket.handshake().subscribe(ign -> {}, cause -> {
                    if (Http1xExchange.this.webSocket.getFallback() != null) {
                        Http1xExchange.this.webSocket.restorePipeline();
                        AbstractExchange.ServerControllerSubscriber serverControllerSubscriber = Http1xExchange.super.createServerControllerSubscriber();
                        Http1xExchange.this.subscriber = serverControllerSubscriber;
                        Http1xExchange.this.webSocket.getFallback().subscribe((CoreSubscriber)serverControllerSubscriber);
                    } else {
                        Http1xExchange.this.hookOnError(cause);
                    }
                }, () -> {
                    Http1xExchange.this.keepAlive = false;
                    Http1xExchange.this.response.headers().status(Status.SWITCHING_PROTOCOLS);
                    Http1xExchange.this.logAccess();
                    Http1xExchange.this.dispose(true);
                });
            } else {
                super.hookOnComplete();
            }
        }
    }

    private class FileRegionDataSubscriber
    extends BaseSubscriber<FileRegion> {
        private FileRegionDataSubscriber() {
        }

        protected void hookOnSubscribe(Subscription subscription) {
            this.request(1L);
        }

        protected void hookOnNext(FileRegion fileRegion) {
            Http1xExchange.this.executeInEventLoop(() -> {
                Http1xExchange.this.transferedLength = (int)((long)Http1xExchange.this.transferedLength + fileRegion.count());
                Http1xExchange.this.encoder.writeFrame(Http1xExchange.this.context, fileRegion, Http1xExchange.this.context.newPromise().addListener(future -> {
                    if (future.isSuccess()) {
                        Http1xExchange.this.handler.exchangeNext(Http1xExchange.this.context, null);
                        this.request(1L);
                    } else {
                        Http1xExchange.this.handler.exchangeError(Http1xExchange.this.context, future.cause());
                        this.cancel();
                        Http1xExchange.this.onCompleteWithError(future.cause());
                    }
                }));
            });
        }

        protected void hookOnComplete() {
            Http1xExchange.this.executeInEventLoop(() -> {
                Http1xResponseTrailers responseTrailers = (Http1xResponseTrailers)Http1xExchange.this.response.trailers();
                ChannelPromise finalizePromise = Http1xExchange.this.context.newPromise();
                if (Http1xExchange.this.acceptTrailers && responseTrailers != null) {
                    Http1xExchange.this.encoder.writeFrame(Http1xExchange.this.context, new FlatLastHttpContent(Unpooled.EMPTY_BUFFER, (HttpHeaders)responseTrailers.getUnderlyingTrailers()), finalizePromise);
                } else {
                    Http1xExchange.this.encoder.writeFrame(Http1xExchange.this.context, LastHttpContent.EMPTY_LAST_CONTENT, finalizePromise);
                }
                Http1xExchange.this.finalizeExchange(finalizePromise, () -> Http1xExchange.this.handler.exchangeComplete(Http1xExchange.this.context));
            });
        }
    }
}

