/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.netty.handler.ssl.CipherSuiteFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class SslCipherSuiteFilter
implements CipherSuiteFilter {
    private HttpServerConfiguration configuration;

    public SslCipherSuiteFilter(HttpServerConfiguration configuration) {
        this.configuration = configuration;
    }

    public String[] filterCipherSuites(Iterable<String> ciphers, List<String> defaultCiphers, Set<String> supportedCiphers) {
        HashSet<String> filteredCiphers = new HashSet<String>();
        for (String cipher : ciphers != null ? ciphers : supportedCiphers) {
            filteredCiphers.add(cipher);
        }
        if (this.configuration.tls_ciphers_includes() != null) {
            filteredCiphers.retainAll(Arrays.asList(this.configuration.tls_ciphers_includes()));
        }
        if (this.configuration.tls_ciphers_excludes() != null) {
            filteredCiphers.removeAll(Arrays.asList(this.configuration.tls_ciphers_excludes()));
        }
        return (String[])filteredCiphers.stream().toArray(String[]::new);
    }
}

