/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.http.server.internal.HttpConnectionGroup;
import io.inverno.mod.http.server.internal.HttpServerChannelConfigurer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;

@ChannelHandler.Sharable
@Bean(visibility=Bean.Visibility.PRIVATE)
public class HttpServerChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private final HttpServerChannelConfigurer channelConfigurer;
    private final HttpConnectionGroup connectionGroup;

    public HttpServerChannelInitializer(HttpServerChannelConfigurer channelConfigurer, HttpConnectionGroup connectionGroup) {
        this.channelConfigurer = channelConfigurer;
        this.connectionGroup = connectionGroup;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        if (!this.connectionGroup.isShuttingDown() && !this.connectionGroup.isClosed()) {
            this.channelConfigurer.configure(ch.pipeline());
            this.connectionGroup.register((Channel)ch);
        } else {
            ch.close();
        }
    }
}

