/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import com.aayushatharva.brotli4j.encoder.Encoder;
import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.Lazy;
import io.inverno.mod.base.net.NetService;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.internal.HttpProtocolNegotiationHandler;
import io.inverno.mod.http.server.internal.http1x.Http1xConnection;
import io.inverno.mod.http.server.internal.http1x.Http1xRequestDecoder;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseEncoder;
import io.inverno.mod.http.server.internal.http2.DirectH2cUpgradeHandler;
import io.inverno.mod.http.server.internal.http2.Http2Connection;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsciiString;
import java.util.ArrayList;
import java.util.function.Supplier;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class HttpServerChannelConfigurer {
    private final HttpServerConfiguration configuration;
    private SslContext sslContext;
    private final ByteBufAllocator allocator;
    private final ByteBufAllocator directAllocator;
    private final Supplier<Http1xConnection> http1xConnectionFactory;
    private final Supplier<Http2Connection> http2ConnectionFactory;
    private final CompressionOptions[] compressionOptions;

    public HttpServerChannelConfigurer(HttpServerConfiguration configuration, NetService netService, @Lazy Supplier<SslContext> sslContextSupplier, Supplier<Http1xConnection> http1xChannelHandlerFactory, Supplier<Http2Connection> http2ChannelHandlerFactory) {
        this.configuration = configuration;
        this.allocator = netService.getByteBufAllocator();
        this.directAllocator = netService.getDirectByteBufAllocator();
        this.http1xConnectionFactory = http1xChannelHandlerFactory;
        this.http2ConnectionFactory = http2ChannelHandlerFactory;
        if (this.configuration.tls_enabled()) {
            this.sslContext = sslContextSupplier.get();
        }
        ArrayList<Object> compressionOptionsList = new ArrayList<Object>();
        compressionOptionsList.add(StandardCompressionOptions.deflate((int)this.configuration.compression_deflate_compressionLevel(), (int)this.configuration.compression_deflate_windowBits(), (int)this.configuration.compression_deflate_memLevel()));
        compressionOptionsList.add(StandardCompressionOptions.gzip((int)this.configuration.compression_gzip_compressionLevel(), (int)this.configuration.compression_gzip_windowBits(), (int)this.configuration.compression_gzip_memLevel()));
        if (Zstd.isAvailable()) {
            compressionOptionsList.add(StandardCompressionOptions.zstd((int)this.configuration.compression_zstd_compressionLevel(), (int)this.configuration.compression_zstd_blockSize(), (int)this.configuration.compression_zstd_maxEncodeSize()));
        }
        if (Brotli.isAvailable()) {
            compressionOptionsList.add(StandardCompressionOptions.brotli((Encoder.Parameters)new Encoder.Parameters().setQuality(this.configuration.compression_brotli_quality()).setMode(Encoder.Mode.of((int)this.configuration.compression_brotli_mode())).setWindow(this.configuration.compression_brotli_window())));
        }
        this.compressionOptions = (CompressionOptions[])compressionOptionsList.stream().toArray(CompressionOptions[]::new);
    }

    public void configure(ChannelPipeline pipeline) {
        if (this.configuration.tls_enabled()) {
            SslHandler sslHandler = this.sslContext.newHandler(this.allocator);
            sslHandler.setHandshakeTimeoutMillis(this.configuration.tls_handshake_timeout());
            pipeline.addLast("sslHandler", (ChannelHandler)sslHandler);
            if (this.configuration.h2_enabled()) {
                pipeline.addLast("protocolNegotiationHandler", (ChannelHandler)new HttpProtocolNegotiationHandler(this));
            } else {
                this.configureHttp1x(pipeline);
            }
        } else if (this.configuration.h2c_enabled()) {
            this.configureH2C(pipeline);
        } else {
            this.configureHttp1x(pipeline);
        }
    }

    public Http1xConnection configureHttp1x(ChannelPipeline pipeline) {
        this.initHttp1x(pipeline);
        return this.handleHttp1x(pipeline);
    }

    private void initHttp1x(ChannelPipeline pipeline) {
        pipeline.addLast("http1xDecoder", (ChannelHandler)new Http1xRequestDecoder());
        pipeline.addLast("http1xEncoder", (ChannelHandler)new Http1xResponseEncoder(this.directAllocator));
        if (this.configuration.decompression_enabled()) {
            pipeline.addLast("http1xDecompressor", (ChannelHandler)new HttpContentDecompressor(false));
        }
        if (this.configuration.compression_enabled()) {
            pipeline.addLast("http1xCompressor", (ChannelHandler)new HttpContentCompressor(this.configuration.compression_contentSizeThreshold(), this.compressionOptions));
        }
    }

    private Http1xConnection handleHttp1x(ChannelPipeline pipeline) {
        Http1xConnection handler = this.http1xConnectionFactory.get();
        pipeline.addLast("connection", (ChannelHandler)handler);
        return handler;
    }

    public Http2Connection configureHttp2(ChannelPipeline pipeline) {
        return this.handleHttp2(pipeline);
    }

    private Http2Connection handleHttp2(ChannelPipeline pipeline) {
        Http2Connection handler = this.http2ConnectionFactory.get();
        pipeline.addLast("connection", (ChannelHandler)handler);
        return handler;
    }

    public void configureH2C(ChannelPipeline pipeline) {
        pipeline.addLast("directH2cHandler", (ChannelHandler)new DirectH2cUpgradeHandler(this::completeDirectH2c, this.http2ConnectionFactory));
        this.initHttp1x(pipeline);
        pipeline.addLast("h2cUpgradeHandler", (ChannelHandler)new HttpServerUpgradeHandler(this::completeH2cUpgrade, this::createH2cUpgradeCodec, this.configuration.h2c_max_content_length()));
        this.handleHttp1x(pipeline);
    }

    private HttpServerUpgradeHandler.UpgradeCodec createH2cUpgradeCodec(CharSequence protocol) {
        if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
            return new Http2ServerUpgradeCodec("connection", (Http2ConnectionHandler)this.http2ConnectionFactory.get());
        }
        return null;
    }

    private void completeDirectH2c(ChannelHandlerContext ctx) {
        this.completeH2cUpgrade(ctx);
        ctx.pipeline().remove("h2cUpgradeHandler");
    }

    private void completeH2cUpgrade(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.remove("http1xEncoder");
        pipeline.remove("http1xDecoder");
        if (this.configuration.decompression_enabled()) {
            pipeline.remove("http1xDecompressor");
        }
        if (this.configuration.compression_enabled()) {
            pipeline.remove("http1xCompressor");
        }
        pipeline.remove("connection");
    }

    @Deprecated
    public Http2Connection startHttp2Upgrade(ChannelPipeline pipeline) {
        pipeline.remove("http1xEncoder");
        if (this.configuration.decompression_enabled()) {
            pipeline.remove("http1xDecompressor");
        }
        if (this.configuration.compression_enabled()) {
            pipeline.remove("http1xCompressor");
        }
        pipeline.remove("connection");
        return this.handleHttp2(pipeline);
    }

    @Deprecated
    public void completeHttp2Upgrade(ChannelPipeline pipeline) {
        pipeline.remove("http1xDecoder");
        pipeline.remove("h2cUpgradeHandler");
    }
}

