/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.base.concurrent.Reactor;
import io.inverno.mod.http.server.internal.HttpConnection;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class HttpConnectionGroup {
    private static final Logger LOGGER = LogManager.getLogger(HttpConnectionGroup.class);
    private final ChannelGroup channelGroup;
    private boolean closing;
    private boolean closed;

    public HttpConnectionGroup(Reactor reactor) {
        this.channelGroup = new DefaultChannelGroup((EventExecutor)reactor.getAcceptorEventLoopGroup().next());
    }

    public void register(Channel channel) {
        this.channelGroup.add((Object)channel);
    }

    private Stream<HttpConnection> getActiveConnections() {
        return this.channelGroup.stream().map(channel -> {
            ChannelHandler handler = channel.pipeline().get("connection");
            if (handler != null && handler instanceof HttpConnection) {
                return (HttpConnection)handler;
            }
            return null;
        }).filter(Objects::nonNull);
    }

    public Mono<Void> shutdown() {
        if (this.closing || this.closed) {
            return Mono.empty();
        }
        return Flux.fromStream(this::getActiveConnections).doFirst(() -> {
            LOGGER.debug("Shutting down connections...");
            this.closing = true;
        }).flatMap(connection -> connection.shutdown()).doOnError(e -> LOGGER.warn("Error shutting down connection", e)).onErrorResume(e -> true, e -> Mono.empty()).doOnTerminate(() -> {
            this.closed = true;
            this.closing = false;
        }).then();
    }

    public Mono<Void> shutdownGracefully() {
        if (this.closing || this.closed) {
            return Mono.empty();
        }
        return Flux.fromStream(this::getActiveConnections).doFirst(() -> {
            LOGGER.debug("Shutting down connections gracefully...");
            this.closing = true;
        }).flatMap(connection -> connection.shutdownGracefully()).doOnError(e -> LOGGER.warn("Error shutting down connection", e)).onErrorResume(e -> true, e -> Mono.empty()).doOnTerminate(() -> {
            this.closed = true;
            this.closing = false;
        }).then();
    }

    public boolean isShuttingDown() {
        return this.closing;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

