/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.mod.base.Charsets;
import io.inverno.mod.http.base.InboundData;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.RequestBody;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCounted;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class GenericRequestBody
implements RequestBody {
    private final Optional<Headers.ContentType> contentType;
    private final MultipartDecoder<Parameter> urlEncodedBodyDecoder;
    private final MultipartDecoder<Part> multipartBodyDecoder;
    Sinks.Many<ByteBuf> dataSink;
    private boolean subscribed;
    private boolean disposed;
    private Flux<ByteBuf> data;
    private InboundData<ByteBuf> rawData;
    private InboundData<CharSequence> stringData;
    private RequestBody.UrlEncoded urlEncodedData;
    private RequestBody.Multipart<Part> multipartData;

    public GenericRequestBody(Optional<Headers.ContentType> contentType, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder) {
        this.contentType = contentType;
        this.urlEncodedBodyDecoder = urlEncodedBodyDecoder;
        this.multipartBodyDecoder = multipartBodyDecoder;
        this.dataSink = Sinks.many().unicast().onBackpressureBuffer();
        this.data = Flux.defer(() -> {
            if (this.disposed) {
                return Mono.error((Throwable)new IllegalStateException("Request was disposed"));
            }
            return this.dataSink.asFlux().doOnSubscribe(ign -> {
                this.subscribed = true;
            }).doOnDiscard(ByteBuf.class, ReferenceCounted::release);
        });
    }

    void dispose() {
        this.dispose(null);
    }

    void dispose(Throwable error) {
        if (!this.disposed) {
            if (!this.subscribed) {
                this.dataSink.asFlux().subscribe(chunk -> chunk.release(), ex -> {});
            } else if (error != null) {
                this.dataSink.tryEmitError(error);
            } else {
                this.dataSink.tryEmitComplete();
            }
            this.disposed = true;
        }
    }

    @Override
    public RequestBody transform(Function<Publisher<ByteBuf>, Publisher<ByteBuf>> transformer) {
        if (this.subscribed) {
            throw new IllegalStateException("Request data already consumed");
        }
        this.data = Flux.from(transformer.apply((Publisher<ByteBuf>)this.data));
        return this;
    }

    @Override
    public InboundData<ByteBuf> raw() {
        if (this.rawData == null) {
            this.rawData = new RawInboundData();
        }
        return this.rawData;
    }

    @Override
    public InboundData<CharSequence> string() throws IllegalStateException {
        if (this.stringData == null) {
            this.stringData = new StringInboundData();
        }
        return this.stringData;
    }

    @Override
    public RequestBody.UrlEncoded urlEncoded() {
        if (this.urlEncodedData == null) {
            this.urlEncodedData = new UrlEncodedInboundData((Publisher<Parameter>)this.urlEncodedBodyDecoder.decode(this.data, this.contentType.orElse(null)));
        }
        return this.urlEncodedData;
    }

    public RequestBody.Multipart<Part> multipart() {
        if (this.multipartData == null) {
            this.multipartData = new MultipartInboundData((Publisher<Part>)this.multipartBodyDecoder.decode(this.data, this.contentType.orElse(null)));
        }
        return this.multipartData;
    }

    private class RawInboundData
    implements InboundData<ByteBuf> {
        private RawInboundData() {
        }

        public Publisher<ByteBuf> stream() {
            return GenericRequestBody.this.data;
        }
    }

    private class StringInboundData
    implements InboundData<CharSequence> {
        private StringInboundData() {
        }

        public Publisher<CharSequence> stream() {
            return GenericRequestBody.this.data.map(buf -> {
                try {
                    String string = buf.toString(Charsets.DEFAULT);
                    return string;
                }
                finally {
                    buf.release();
                }
            });
        }
    }

    private class UrlEncodedInboundData
    implements RequestBody.UrlEncoded {
        private final Publisher<Parameter> parameters;
        private Mono<Map<String, Parameter>> parametersMap;

        public UrlEncodedInboundData(Publisher<Parameter> parameters) {
            this.parameters = Flux.from(parameters).cache();
        }

        public Publisher<Parameter> stream() {
            return this.parameters;
        }

        @Override
        public Mono<Map<String, Parameter>> collectMap() {
            if (this.parametersMap == null) {
                this.parametersMap = Flux.from(this.parameters).collectMap(Parameter::getName).cache();
            }
            return this.parametersMap;
        }
    }

    private class MultipartInboundData
    implements RequestBody.Multipart<Part> {
        private final Publisher<Part> parts;

        public MultipartInboundData(Publisher<Part> parts) {
            this.parts = parts;
        }

        public Publisher<Part> stream() {
            return this.parts;
        }
    }
}

