/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.mod.http.base.InboundHeaders;
import io.inverno.mod.http.base.OutboundHeaders;
import io.inverno.mod.http.base.OutboundResponseHeaders;
import io.inverno.mod.http.base.OutboundSetCookies;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.Response;
import io.inverno.mod.http.server.internal.GenericResponseBody;
import io.inverno.mod.http.server.internal.InternalResponseHeaders;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;

public abstract class AbstractResponse
implements Response {
    protected final ChannelHandlerContext context;
    protected final HeaderService headerService;
    protected final InternalResponseHeaders responseHeaders;
    protected GenericResponseBody responseBody;
    protected OutboundHeaders<?> responseTrailers;

    public AbstractResponse(ChannelHandlerContext context, HeaderService headerService, InternalResponseHeaders responseHeaders) {
        this.context = context;
        this.headerService = headerService;
        this.responseHeaders = responseHeaders;
    }

    public boolean isSingle() {
        return this.responseBody.isSingle();
    }

    public void dataSubscribe(Subscriber<ByteBuf> s) {
        this.responseBody.dataSubscribe(s);
    }

    @Override
    public boolean isHeadersWritten() {
        return this.responseHeaders.isWritten();
    }

    public InternalResponseHeaders headers() {
        return this.responseHeaders;
    }

    @Override
    public AbstractResponse headers(Consumer<OutboundResponseHeaders> headersConfigurer) {
        if (this.responseHeaders.isWritten()) {
            throw new IllegalStateException("Headers already written");
        }
        if (headersConfigurer != null) {
            headersConfigurer.accept(this.responseHeaders);
        }
        return this;
    }

    @Override
    @Deprecated
    public AbstractResponse cookies(Consumer<OutboundSetCookies> cookiesConfigurer) {
        this.responseHeaders.cookies(cookiesConfigurer);
        return this;
    }

    @Override
    public GenericResponseBody body() {
        return this.responseBody;
    }

    public InboundHeaders trailers() {
        if (this.responseTrailers == null) {
            this.responseTrailers = this.createTrailers();
        }
        return this.responseTrailers;
    }

    @Override
    public Response trailers(Consumer<OutboundHeaders<?>> trailersConfigurer) {
        if (trailersConfigurer != null) {
            trailersConfigurer.accept((OutboundHeaders)this.trailers());
        }
        return this;
    }

    protected abstract OutboundHeaders<?> createTrailers();
}

