/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.multipart;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.header.ContentTypeCodec;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.internal.multipart.GenericPart;
import io.inverno.mod.http.server.internal.multipart.MalformedBodyException;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.SignalType;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class MultipartFormDataBodyDecoder
implements MultipartDecoder<Part> {
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;

    public MultipartFormDataBodyDecoder(HeaderService headerService, ObjectConverter<String> parameterConverter) {
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
    }

    @Override
    public Flux<Part> decode(Flux<ByteBuf> data, Headers.ContentType contentType) {
        if (contentType == null || !contentType.getMediaType().equalsIgnoreCase("multipart/form-data")) {
            throw new IllegalArgumentException("Content type is not multipart/form-data");
        }
        if (contentType.getBoundary() == null) {
            throw new IllegalArgumentException("Missing multipart form data boundary");
        }
        return Flux.create(emitter -> data.subscribe((CoreSubscriber)new BodyDataSubscriber(contentType, (FluxSink<Part>)emitter)));
    }

    private DecoderTask boundary(ByteBuf buffer, BodyDataSubscriber context) throws MalformedBodyException {
        byte nextByte;
        int delimiterPos;
        String delimiter = context.getDelimiter();
        int readerIndex = buffer.readerIndex();
        if (!this.skipControlCharacters(buffer)) {
            buffer.readerIndex(readerIndex);
        }
        this.skipOneLine(buffer);
        readerIndex = buffer.readerIndex();
        int len = delimiter.length();
        for (delimiterPos = 0; buffer.isReadable() && delimiterPos < len; ++delimiterPos) {
            nextByte = buffer.readByte();
            if (nextByte == delimiter.charAt(delimiterPos)) {
                continue;
            }
            throw new MalformedBodyException("No delimiter found");
        }
        if (delimiterPos < len - 1) {
            buffer.readerIndex(readerIndex);
            return null;
        }
        if (buffer.isReadable()) {
            nextByte = buffer.readByte();
            if (nextByte == 13) {
                if (buffer.isReadable()) {
                    nextByte = buffer.readByte();
                    if (nextByte == 10) {
                        return this::headers;
                    }
                    throw new MalformedBodyException("No delimiter found");
                }
            } else {
                if (nextByte == 10) {
                    return this::headers;
                }
                if (nextByte == 45 && buffer.isReadable() && (nextByte = buffer.readByte()) == 45) {
                    return this::end;
                }
            }
        }
        buffer.readerIndex(readerIndex);
        return null;
    }

    private DecoderTask headers(ByteBuf buffer, BodyDataSubscriber context) throws MalformedBodyException {
        while (!this.skipOneLine(buffer)) {
            Header headerField = this.headerService.decode(buffer, context.contentType.getCharset());
            if (headerField != null) {
                context.addDecodedHeader(headerField);
                continue;
            }
            return null;
        }
        Headers.ContentDisposition partContentDispositionHeader = (Headers.ContentDisposition)context.getDecodedHeader("content-disposition");
        if (partContentDispositionHeader == null || partContentDispositionHeader.getPartName() == null) {
            throw new MalformedBodyException("Missing content disposition");
        }
        Headers.ContentType partContentTypeHeader = (Headers.ContentType)context.getDecodedHeader("content-type");
        if (partContentTypeHeader != null && partContentTypeHeader.getMediaType().equalsIgnoreCase("multipart/mixed")) {
            context.startMultipartMixed(partContentTypeHeader);
            return this::boundary;
        }
        String partName = partContentDispositionHeader.getPartName();
        String partFilename = partContentDispositionHeader.getFilename();
        if (context.isMultipartMixed() && partFilename == null) {
            throw new MalformedBodyException("Field not supported in mixed multipart");
        }
        if (partContentTypeHeader == null && partFilename != null) {
            context.addDecodedHeader((Header)new ContentTypeCodec.ContentType("application/octet-stream", context.contentType.getCharset(), null, null));
        }
        context.startPart(new GenericPart(this.parameterConverter, partName, partFilename, context.getAllDecodedHeaders()));
        return this::data;
    }

    private DecoderTask data(ByteBuf buffer, BodyDataSubscriber context) {
        String delimiter = context.getDelimiter();
        int readerIndex = buffer.readerIndex();
        int delimiterLength = delimiter.length();
        Integer delimiterIndex = null;
        Integer delimiterReaderIndex = null;
        while (buffer.isReadable()) {
            byte nextByte = buffer.readByte();
            if (nextByte == 13) {
                if (!buffer.isReadable()) {
                    delimiterIndex = 0;
                    delimiterReaderIndex = buffer.readerIndex() - 1;
                    continue;
                }
                if (buffer.getByte(buffer.readerIndex()) != 10) continue;
                buffer.readByte();
                delimiterIndex = 0;
                delimiterReaderIndex = buffer.readerIndex() - 2;
                continue;
            }
            if (nextByte == 10) {
                delimiterIndex = 0;
                delimiterReaderIndex = buffer.readerIndex() - 1;
                continue;
            }
            if (delimiterIndex == null) continue;
            if (nextByte == delimiter.codePointAt(delimiterIndex)) {
                Integer n = delimiterIndex;
                delimiterIndex = delimiterIndex + 1;
                if (delimiterIndex != delimiterLength) continue;
                if (readerIndex < delimiterReaderIndex) {
                    context.getPart().data().tryEmitNext((Object)buffer.retainedSlice(readerIndex, delimiterReaderIndex - readerIndex));
                }
                return this::end;
            }
            delimiterReaderIndex = null;
            delimiterIndex = null;
        }
        int dataLength = (delimiterReaderIndex != null ? delimiterReaderIndex.intValue() : buffer.readerIndex()) - readerIndex;
        if (dataLength > 0) {
            context.getPart().data().tryEmitNext((Object)buffer.retainedSlice(readerIndex, dataLength));
        }
        buffer.readerIndex(readerIndex + dataLength);
        return null;
    }

    private DecoderTask end(ByteBuf buffer, BodyDataSubscriber context) {
        context.endPart();
        int readerIndex = buffer.readerIndex();
        if (buffer.readableBytes() >= 2) {
            if (buffer.readByte() == 45 && buffer.readByte() == 45) {
                if (context.isMultipartMixed()) {
                    context.endMultipartMixed();
                    return this::boundary;
                }
                context.complete();
                return null;
            }
            buffer.readerIndex(readerIndex);
            this.skipOneLine(buffer);
            return this::headers;
        }
        return null;
    }

    private boolean skipControlCharacters(ByteBuf buffer) {
        try {
            char c;
            while (Character.isISOControl(c = (char)buffer.readUnsignedByte()) || Character.isWhitespace(c)) {
            }
            buffer.readerIndex(buffer.readerIndex() - 1);
        }
        catch (IndexOutOfBoundsException e1) {
            return false;
        }
        return true;
    }

    private boolean skipOneLine(ByteBuf buffer) {
        if (!buffer.isReadable()) {
            return false;
        }
        byte nextByte = buffer.readByte();
        if (nextByte == 13) {
            if (!buffer.isReadable()) {
                buffer.readerIndex(buffer.readerIndex() - 1);
                return false;
            }
            nextByte = buffer.readByte();
            if (nextByte == 10) {
                return true;
            }
            buffer.readerIndex(buffer.readerIndex() - 2);
            return false;
        }
        if (nextByte == 10) {
            return true;
        }
        buffer.readerIndex(buffer.readerIndex() - 1);
        return false;
    }

    private class BodyDataSubscriber
    extends BaseSubscriber<ByteBuf> {
        private final Headers.ContentType contentType;
        private final FluxSink<Part> emitter;
        private ByteBuf keepBuffer;
        private final String delimiter;
        private String mixedDelimiter;
        private DecoderTask task;
        private GenericPart part;
        private Map<String, List<Header>> decodedHeaders;
        private boolean canceling;

        public BodyDataSubscriber(Headers.ContentType contentType, FluxSink<Part> emitter) {
            this.contentType = contentType;
            this.delimiter = "--" + contentType.getBoundary();
            this.task = MultipartFormDataBodyDecoder.this::boundary;
            this.emitter = emitter;
            this.emitter.onCancel(() -> {
                this.canceling = true;
                if (this.part == null) {
                    this.cancel();
                }
            });
        }

        public String getDelimiter() {
            return this.mixedDelimiter != null ? this.mixedDelimiter : this.delimiter;
        }

        public void startMultipartMixed(Headers.ContentType partContentType) throws MalformedBodyException {
            if (this.mixedDelimiter != null) {
                throw new MalformedBodyException("Nested multipart mixed not allowed");
            }
            if (partContentType.getBoundary() == null) {
                throw new MalformedBodyException("Missing multipart mixed boundary");
            }
            this.mixedDelimiter = "--" + partContentType.getBoundary();
            this.part = null;
            this.decodedHeaders = null;
        }

        public boolean isMultipartMixed() {
            return this.mixedDelimiter != null;
        }

        public void endMultipartMixed() {
            this.mixedDelimiter = null;
            this.part = null;
            this.decodedHeaders = null;
        }

        public void startPart(GenericPart part) {
            this.part = part;
            this.emitter.next((Object)this.part);
        }

        public GenericPart getPart() {
            return this.part;
        }

        public void endPart() {
            if (this.part != null) {
                this.part.data().tryEmitComplete();
                this.endPart(null);
            }
        }

        public void endPart(Throwable error) {
            if (this.part != null) {
                this.part.dispose(error);
                this.part = null;
                this.decodedHeaders = null;
                if (this.canceling) {
                    this.cancel();
                }
            }
        }

        public void complete() {
            this.emitter.complete();
            this.cancel();
        }

        public void addDecodedHeader(Header decodedHeaderField) {
            List<Header> headerFieldList;
            if (this.decodedHeaders == null) {
                this.decodedHeaders = new LinkedHashMap<String, List<Header>>();
            }
            if ((headerFieldList = this.decodedHeaders.get(decodedHeaderField.getHeaderName())) == null) {
                headerFieldList = new ArrayList<Header>();
                this.decodedHeaders.put(decodedHeaderField.getHeaderName(), headerFieldList);
            }
            headerFieldList.add(decodedHeaderField);
        }

        public Map<String, List<Header>> getAllDecodedHeaders() {
            return this.decodedHeaders;
        }

        public <T> List<T> getDecodedHeaders(String name) {
            return this.decodedHeaders.get(name);
        }

        public <T> T getDecodedHeader(String name) {
            List<T> headers = this.getDecodedHeaders(name);
            if (headers == null || headers.isEmpty()) {
                return null;
            }
            if (headers.size() > 1) {
                throw new IllegalStateException("Invalid request");
            }
            return headers.get(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void hookOnNext(ByteBuf value) {
            ByteBuf buffer = this.keepBuffer != null && this.keepBuffer.isReadable() ? Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.keepBuffer, value}) : value;
            try {
                DecoderTask currentTask = this.task;
                while ((currentTask = currentTask.run(buffer, this)) != null && !this.isDisposed()) {
                    this.task = currentTask;
                }
                if (!this.isDisposed()) {
                    if (buffer.isReadable()) {
                        if (this.keepBuffer != null) {
                            this.keepBuffer.discardReadBytes();
                            this.keepBuffer.writeBytes(buffer);
                        } else {
                            this.keepBuffer = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.buffer((int)buffer.readableBytes()));
                            this.keepBuffer.writeBytes(buffer);
                        }
                    } else {
                        this.keepBuffer = null;
                    }
                }
            }
            catch (Throwable e) {
                this.emitter.error(e);
                this.cancel();
            }
            finally {
                buffer.release();
            }
        }

        protected void hookOnError(Throwable throwable) {
            this.emitter.error(throwable);
        }

        protected void hookOnComplete() {
            this.emitter.complete();
        }

        protected void hookFinally(SignalType type) {
            this.endPart();
            if (this.keepBuffer != null) {
                this.keepBuffer.release();
                this.keepBuffer = null;
            }
        }
    }

    @FunctionalInterface
    private static interface DecoderTask {
        public DecoderTask run(ByteBuf var1, BodyDataSubscriber var2) throws MalformedBodyException;
    }
}

