/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.multipart;

import io.inverno.mod.base.Charsets;
import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.InboundData;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.internal.multipart.PartHeaders;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCounted;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

class GenericPart
implements Part {
    private String name;
    private String filename;
    private PartHeaders partHeaders;
    private Sinks.Many<ByteBuf> dataSink;
    private boolean subscribed;
    private boolean disposed;
    private Flux<ByteBuf> data;
    private InboundData<ByteBuf> rawData;
    private InboundData<CharSequence> stringData;

    public GenericPart(ObjectConverter<String> parameterConverter, String name, Map<String, List<Header>> headers) {
        this(parameterConverter, name, null, headers);
    }

    public GenericPart(ObjectConverter<String> parameterConverter, String name, String filename, Map<String, List<Header>> headers) {
        this.name = name;
        this.filename = filename;
        this.partHeaders = new PartHeaders(headers, parameterConverter);
        this.dataSink = Sinks.many().unicast().onBackpressureBuffer();
        this.data = Flux.defer(() -> {
            if (this.disposed) {
                return Mono.error((Throwable)new IllegalStateException("Part was disposed"));
            }
            return this.dataSink.asFlux().doOnSubscribe(ign -> {
                this.subscribed = true;
            }).doOnDiscard(ByteBuf.class, ReferenceCounted::release);
        });
    }

    void dispose() {
        this.dispose(null);
    }

    void dispose(Throwable error) {
        if (!this.subscribed) {
            this.dataSink.asFlux().subscribe(chunk -> chunk.release(), ex -> {});
        } else {
            this.dataSink.tryEmitError(error != null ? error : new IllegalStateException("Part was disposed"));
        }
        this.disposed = true;
    }

    Sinks.Many<ByteBuf> data() {
        return this.dataSink;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<String> getFilename() {
        return Optional.ofNullable(this.filename);
    }

    @Override
    public PartHeaders headers() {
        return this.partHeaders;
    }

    @Override
    public InboundData<ByteBuf> raw() {
        if (this.rawData == null) {
            this.rawData = new RawInboundData();
        }
        return this.rawData;
    }

    @Override
    public InboundData<CharSequence> string() {
        if (this.stringData == null) {
            this.stringData = new StringInboundData();
        }
        return this.stringData;
    }

    private class RawInboundData
    implements InboundData<ByteBuf> {
        private RawInboundData() {
        }

        public Publisher<ByteBuf> stream() {
            return GenericPart.this.data;
        }
    }

    private class StringInboundData
    implements InboundData<CharSequence> {
        private StringInboundData() {
        }

        public Publisher<CharSequence> stream() {
            return GenericPart.this.data.map(buf -> {
                try {
                    String string = buf.toString(Charsets.DEFAULT);
                    return string;
                }
                finally {
                    buf.release();
                }
            });
        }
    }
}

