/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.http.base.internal.netty.FlatFullHttpResponse;
import io.inverno.mod.http.base.internal.netty.LinkedHttpHeaders;
import io.inverno.mod.http.server.internal.HttpServerChannelConfigurer;
import io.inverno.mod.http.server.internal.http2.Http2Connection;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.List;

@Deprecated
public class H2cUpgradeHandler
extends ChannelInboundHandlerAdapter {
    private final HttpServerChannelConfigurer configurer;
    private Http2Connection http2Connection;
    private boolean upgrading;

    public H2cUpgradeHandler(HttpServerChannelConfigurer configurer) {
        this.configurer = configurer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.upgrading |= msg instanceof HttpRequest && ((HttpRequest)msg).headers().contains("upgrade", "h2c", true);
        if (!this.upgrading) {
            ctx.fireChannelRead(msg);
            return;
        }
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            HttpHeaders requestHeaders = request.headers();
            String connection = requestHeaders.get("connection");
            if (connection != null && connection.length() > 0) {
                List http2SettingsHeader;
                int connectionIndex = 0;
                int length = connection.length();
                String currentHeader = null;
                int currentHeaderIndex = 0;
                boolean skip = false;
                int headersFound = 0;
                while (connectionIndex < length) {
                    char nextChar;
                    if ((nextChar = Character.toLowerCase(connection.charAt(connectionIndex++))) == ',' || connectionIndex == length) {
                        if (!skip) {
                            ++headersFound;
                        }
                        currentHeader = null;
                        currentHeaderIndex = 0;
                        skip = false;
                        continue;
                    }
                    if (skip || nextChar == ' ') continue;
                    if (currentHeader == null) {
                        if (nextChar == "upgrade".charAt(currentHeaderIndex)) {
                            currentHeader = "upgrade";
                        } else if (nextChar == "http2-settings".charAt(currentHeaderIndex)) {
                            currentHeader = "http2-settings";
                        } else {
                            skip = true;
                        }
                        ++currentHeaderIndex;
                        continue;
                    }
                    skip = nextChar != currentHeader.charAt(currentHeaderIndex++);
                }
                if (headersFound != 2) {
                    this.sendBadRequest(request.protocolVersion(), ctx);
                }
                if ((http2SettingsHeader = requestHeaders.getAll("http2-settings")).isEmpty() || http2SettingsHeader.size() > 1) {
                    this.sendBadRequest(request.protocolVersion(), ctx);
                }
                try {
                    Http2Settings requestHttp2Settings = this.decodeSettingsHeader((CharSequence)http2SettingsHeader.get(0));
                    this.sendAcceptUpgrade(request.protocolVersion(), ctx);
                    this.http2Connection = this.configurer.startHttp2Upgrade(ctx.pipeline());
                    this.http2Connection.onHttpServerUpgrade(requestHttp2Settings);
                    this.http2Connection.onSettingsRead(ctx, requestHttp2Settings);
                    DefaultHttp2Headers headers = new DefaultHttp2Headers();
                    headers.method((CharSequence)request.method().name());
                    headers.path((CharSequence)request.uri());
                    headers.authority((CharSequence)request.headers().get("host"));
                    headers.scheme((CharSequence)"http");
                    request.headers().remove("http2-settings");
                    request.headers().remove("host");
                    request.headers().forEach(header -> headers.set((Object)((String)header.getKey()).toLowerCase(), (Object)((CharSequence)header.getValue())));
                    this.http2Connection.onHeadersRead(ctx, 1, (Http2Headers)headers, 0, false);
                }
                catch (IOException e) {
                    this.sendBadRequest(request.protocolVersion(), ctx);
                }
            }
        } else if (this.http2Connection != null && msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            boolean endStream = content instanceof LastHttpContent;
            try {
                this.http2Connection.onDataRead(ctx, 1, content.content(), 0, endStream);
                if (endStream) {
                    this.configurer.completeHttp2Upgrade(ctx.pipeline());
                }
            }
            finally {
                content.content().release();
            }
        }
    }

    private ChannelFuture sendBadRequest(HttpVersion version, ChannelHandlerContext ctx) {
        LinkedHttpHeaders responseHeaders = new LinkedHttpHeaders();
        responseHeaders.add("connection", (Object)"close");
        FlatFullHttpResponse response = new FlatFullHttpResponse(version, HttpResponseStatus.BAD_REQUEST, (HttpHeaders)responseHeaders, Unpooled.EMPTY_BUFFER, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        return ctx.writeAndFlush((Object)response);
    }

    private ChannelFuture sendAcceptUpgrade(HttpVersion version, ChannelHandlerContext ctx) {
        LinkedHttpHeaders responseHeaders = new LinkedHttpHeaders();
        responseHeaders.add("connection", (Object)"upgrade");
        responseHeaders.add("upgrade", (Object)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME);
        FlatFullHttpResponse response = new FlatFullHttpResponse(version, HttpResponseStatus.SWITCHING_PROTOCOLS, (HttpHeaders)responseHeaders, Unpooled.EMPTY_BUFFER, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        return ctx.writeAndFlush((Object)response);
    }

    private Http2Settings decodeSettingsHeader(CharSequence settingsHeader) throws IOException {
        Http2Settings http2Settings = new Http2Settings();
        byte[] settingsHeaderBytes = Base64.getUrlDecoder().decode(settingsHeader.toString());
        try (DataInputStream settingsDataStream = new DataInputStream(new ByteArrayInputStream(settingsHeaderBytes));){
            for (int readCount = 0; readCount < settingsHeaderBytes.length; readCount += 6) {
                int identifier = settingsDataStream.readUnsignedShort();
                long value = Integer.toUnsignedLong(settingsDataStream.readInt());
                http2Settings.put((char)identifier, Long.valueOf(value));
            }
            Http2Settings http2Settings2 = http2Settings;
            return http2Settings2;
        }
    }
}

