/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.OutboundHeaders;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.internal.GenericParameter;
import io.inverno.mod.http.base.internal.netty.LinkedHttpHeaders;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class Http1xResponseTrailers
implements OutboundHeaders<Http1xResponseTrailers> {
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final LinkedHttpHeaders underlyingTrailers;
    private boolean written;

    public Http1xResponseTrailers(HeaderService headerService, ObjectConverter<String> parameterConverter) {
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.underlyingTrailers = new LinkedHttpHeaders();
    }

    public boolean isWritten() {
        return this.written;
    }

    public void setWritten(boolean written) {
        this.written = written;
    }

    LinkedHttpHeaders getUnderlyingTrailers() {
        return this.underlyingTrailers;
    }

    public Http1xResponseTrailers add(CharSequence name, CharSequence value) {
        this.underlyingTrailers.addCharSequence(name, value);
        return this;
    }

    public Http1xResponseTrailers add(Header ... trailers) {
        for (Header trailer : trailers) {
            this.underlyingTrailers.addCharSequence((CharSequence)trailer.getHeaderName(), (CharSequence)trailer.getHeaderValue());
        }
        return this;
    }

    public Http1xResponseTrailers set(CharSequence name, CharSequence value) {
        this.underlyingTrailers.setCharSequence(name, value);
        return this;
    }

    public Http1xResponseTrailers set(Header ... trailers) {
        for (Header trailer : trailers) {
            this.underlyingTrailers.setCharSequence((CharSequence)trailer.getHeaderName(), (CharSequence)trailer.getHeaderValue());
        }
        return this;
    }

    public Http1xResponseTrailers remove(CharSequence ... names) {
        for (CharSequence name : names) {
            this.underlyingTrailers.remove(name);
        }
        return this;
    }

    public boolean contains(CharSequence name) {
        return this.underlyingTrailers.contains(name);
    }

    public boolean contains(CharSequence name, CharSequence value) {
        return this.underlyingTrailers.contains(name, value, true);
    }

    public Set<String> getNames() {
        return this.underlyingTrailers.names();
    }

    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable(this.underlyingTrailers.get(name));
    }

    public List<String> getAll(CharSequence name) {
        return this.underlyingTrailers.getAll(name);
    }

    public List<Map.Entry<String, String>> getAll() {
        return this.underlyingTrailers.entries();
    }

    public <T extends Header> Optional<T> getHeader(CharSequence name) {
        return this.get(name).map(value -> this.headerService.decode(name.toString(), value));
    }

    public <T extends Header> List<T> getAllHeader(CharSequence name) {
        return this.getAll(name).stream().map(value -> this.headerService.decode(name.toString(), value)).collect(Collectors.toList());
    }

    public List<Header> getAllHeader() {
        return this.getAll().stream().map(e -> this.headerService.decode((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    public Optional<Parameter> getParameter(CharSequence name) {
        return this.get(name).map(value -> new GenericParameter(name.toString(), value, this.parameterConverter));
    }

    public List<Parameter> getAllParameter(CharSequence name) {
        return this.getAll(name).stream().map(value -> new GenericParameter(name.toString(), value, this.parameterConverter)).collect(Collectors.toList());
    }

    public List<Parameter> getAllParameter() {
        return this.getAll().stream().map(e -> new GenericParameter((String)e.getKey(), (String)e.getValue(), this.parameterConverter)).collect(Collectors.toList());
    }
}

