/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.OutboundHeaders;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.Response;
import io.inverno.mod.http.server.internal.AbstractResponse;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseBody;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseHeaders;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseTrailers;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslHandler;

class Http1xResponse
extends AbstractResponse {
    private final HttpVersion version;
    private final ObjectConverter<String> parameterConverter;

    public Http1xResponse(HttpVersion version, ChannelHandlerContext context, HeaderService headerService, ObjectConverter<String> parameterConverter) {
        super(context, headerService, new Http1xResponseHeaders(headerService, parameterConverter));
        this.version = version;
        this.parameterConverter = parameterConverter;
        this.responseBody = new Http1xResponseBody(this);
    }

    protected boolean supportsFileRegion() {
        return this.context.pipeline().get(SslHandler.class) == null && this.context.pipeline().get(HttpContentCompressor.class) == null;
    }

    @Override
    public Http1xResponseHeaders headers() {
        return (Http1xResponseHeaders)this.responseHeaders;
    }

    @Override
    protected OutboundHeaders<?> createTrailers() {
        return new Http1xResponseTrailers(this.headerService, this.parameterConverter);
    }

    public Http1xResponseTrailers trailers() {
        return (Http1xResponseTrailers)this.responseTrailers;
    }

    @Override
    public Response sendContinue() {
        this.context.writeAndFlush((Object)new DefaultFullHttpResponse(this.version, HttpResponseStatus.CONTINUE));
        return this;
    }

    @Override
    public Http1xResponseBody body() {
        return (Http1xResponseBody)super.body();
    }
}

