/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.InboundCookies;
import io.inverno.mod.http.base.InboundRequestHeaders;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.GenericParameter;
import io.inverno.mod.http.base.internal.netty.LinkedHttpHeaders;
import io.inverno.mod.http.server.internal.GenericRequestCookies;
import io.netty.handler.codec.http.HttpRequest;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class Http1xRequestHeaders
implements InboundRequestHeaders {
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final LinkedHttpHeaders underlyingHeaders;
    private InboundCookies requestCookies;

    public Http1xRequestHeaders(HttpRequest httpRequest, HeaderService headerService, ObjectConverter<String> parameterConverter) {
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.underlyingHeaders = (LinkedHttpHeaders)httpRequest.headers();
    }

    LinkedHttpHeaders getUnderlyingHeaders() {
        return this.underlyingHeaders;
    }

    public String getContentType() {
        return this.underlyingHeaders.get((CharSequence)"content-type");
    }

    public Headers.ContentType getContentTypeHeader() {
        return this.getHeader("content-type").orElse(null);
    }

    public Long getContentLength() {
        return this.underlyingHeaders.getLong((CharSequence)"content-length");
    }

    public InboundCookies cookies() {
        if (this.requestCookies == null) {
            this.requestCookies = new GenericRequestCookies(this, this.parameterConverter);
        }
        return this.requestCookies;
    }

    public boolean contains(CharSequence name) {
        return this.underlyingHeaders.contains(name);
    }

    public boolean contains(CharSequence name, CharSequence value) {
        return this.underlyingHeaders.contains(name, value, true);
    }

    public Set<String> getNames() {
        return this.underlyingHeaders.names();
    }

    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable(this.underlyingHeaders.get(name));
    }

    public List<String> getAll(CharSequence name) {
        return this.underlyingHeaders.getAll(name);
    }

    public List<Map.Entry<String, String>> getAll() {
        return this.underlyingHeaders.entries();
    }

    public <T extends Header> Optional<T> getHeader(CharSequence name) {
        return this.get(name).map(value -> this.headerService.decode(name.toString(), value));
    }

    public <T extends Header> List<T> getAllHeader(CharSequence name) {
        return this.underlyingHeaders.getAll(name).stream().map(value -> this.headerService.decode(name.toString(), value)).collect(Collectors.toList());
    }

    public List<Header> getAllHeader() {
        return this.underlyingHeaders.entries().stream().map(e -> this.headerService.decode((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    public Optional<Parameter> getParameter(CharSequence name) {
        return this.get(name).map(value -> new GenericParameter(name.toString(), value, this.parameterConverter));
    }

    public List<Parameter> getAllParameter(CharSequence name) {
        return this.underlyingHeaders.getAll(name).stream().map(value -> new GenericParameter(name.toString(), value, this.parameterConverter)).collect(Collectors.toList());
    }

    public List<Parameter> getAllParameter() {
        return this.underlyingHeaders.entries().stream().map(e -> new GenericParameter((String)e.getKey(), (String)e.getValue(), this.parameterConverter)).collect(Collectors.toList());
    }
}

