/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.Init;
import io.inverno.core.annotation.Wrapper;
import io.inverno.mod.base.resource.Resource;
import io.inverno.mod.base.resource.ResourceService;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.IOException;
import java.nio.channels.Channels;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;

@Bean(visibility=Bean.Visibility.PRIVATE, strategy=Bean.Strategy.PROTOTYPE)
@Wrapper
public class SslContextWrapper
implements Supplier<SslContext> {
    private final HttpServerConfiguration configuration;
    private final ResourceService resourceService;
    private CipherSuiteFilter cipherSuiteFilter = SupportedCipherSuiteFilter.INSTANCE;
    private SslContext sslContext;

    public SslContextWrapper(HttpServerConfiguration configuration, ResourceService resourceService) {
        this.configuration = configuration;
        this.resourceService = resourceService;
    }

    public void setCipherSuiteFilter(CipherSuiteFilter cipherSuiteFilter) {
        this.cipherSuiteFilter = cipherSuiteFilter;
    }

    @Init
    public void init() {
        if (this.configuration.tls_key_store() == null) {
            throw new RuntimeException("tls_key_store is missing");
        }
        try (Resource keystoreResource = this.resourceService.getResource(this.configuration.tls_key_store());){
            keystoreResource.openReadableByteChannel().ifPresentOrElse(ksChannel -> {
                try {
                    KeyStore ks = KeyStore.getInstance(this.configuration.tls_key_store_type());
                    ks.load(Channels.newInputStream(ksChannel), this.configuration.tls_key_store_password().toCharArray());
                    String keyPassword = this.configuration.tls_key_store_password();
                    if (this.configuration.tls_key_alias() != null) {
                        if (!ks.containsAlias(this.configuration.tls_key_alias())) {
                            throw new IllegalArgumentException("tls_key_store does not contain alias: " + this.configuration.tls_key_alias());
                        }
                        for (String alias : Collections.list(ks.aliases())) {
                            if (this.configuration.tls_key_alias().equals(alias)) continue;
                            ks.deleteEntry(alias);
                        }
                        if (this.configuration.tls_key_alias_password() != null) {
                            keyPassword = this.configuration.tls_key_alias_password();
                        }
                    }
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    kmf.init(ks, keyPassword.toCharArray());
                    SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((KeyManagerFactory)kmf);
                    SslProvider sslProvider = SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL) ? SslProvider.OPENSSL : SslProvider.JDK;
                    sslContextBuilder.sslProvider(sslProvider);
                    switch (this.configuration.tls_client_auth()) {
                        case REQUESTED: {
                            sslContextBuilder.clientAuth(ClientAuth.OPTIONAL);
                            break;
                        }
                        case REQUIRED: {
                            sslContextBuilder.clientAuth(ClientAuth.REQUIRE);
                            break;
                        }
                    }
                    if (this.configuration.tls_trust_store() != null) {
                        try (Resource trustStoreResource = this.resourceService.getResource(this.configuration.tls_trust_store());){
                            trustStoreResource.openReadableByteChannel().ifPresent(tsChannel -> {
                                try {
                                    KeyStore ts = KeyStore.getInstance(this.configuration.tls_trust_store_type());
                                    ts.load(Channels.newInputStream(tsChannel), this.configuration.tls_trust_store_password().toCharArray());
                                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                                    tmf.init(ts);
                                    sslContextBuilder.trustManager(tmf);
                                }
                                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                                    throw new RuntimeException("Error initializing SSL context", e);
                                }
                            });
                        }
                    } else if (this.configuration.tls_trust_manager_factory() != null) {
                        sslContextBuilder.trustManager(this.configuration.tls_trust_manager_factory());
                    }
                    if (sslProvider == SslProvider.OPENSSL) {
                        sslContextBuilder.ciphers((Iterable)OpenSsl.availableOpenSslCipherSuites(), this.cipherSuiteFilter);
                    } else {
                        sslContextBuilder.ciphers((Iterable)OpenSsl.availableOpenSslCipherSuites(), this.cipherSuiteFilter);
                        try {
                            SSLContext context = SSLContext.getInstance("TLS");
                            context.init(null, null, null);
                            SSLEngine engine = context.createSSLEngine();
                            sslContextBuilder.ciphers(Arrays.asList(engine.getEnabledCipherSuites()));
                        }
                        catch (KeyManagementException e) {
                            throw new RuntimeException("Error initializing SSL context", e);
                        }
                    }
                    if (this.configuration.h2_enabled()) {
                        ApplicationProtocolConfig apn = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"});
                        sslContextBuilder.applicationProtocolConfig(apn);
                    }
                    this.sslContext = sslContextBuilder.build();
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                    throw new RuntimeException("Error initializing SSL context", e);
                }
            }, () -> {
                throw new IllegalStateException("tls_key_store does not exist or is not readable: " + String.valueOf(this.configuration.tls_key_store()));
            });
        }
    }

    @Override
    public SslContext get() {
        return this.sslContext;
    }
}

