/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.HttpException;
import io.inverno.mod.http.base.MethodNotAllowedException;
import io.inverno.mod.http.base.ServiceUnavailableException;
import io.inverno.mod.http.base.Status;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.ExchangeHandler;
import io.inverno.mod.http.server.Response;
import java.util.stream.Collectors;

public class GenericErrorExchangeHandler
implements ExchangeHandler<ExchangeContext, ErrorExchange<ExchangeContext>> {
    public static final GenericErrorExchangeHandler INSTANCE = new GenericErrorExchangeHandler();

    @Override
    public void handle(ErrorExchange<ExchangeContext> errorExchange) throws HttpException {
        if (((Response)errorExchange.response()).isHeadersWritten()) {
            throw new IllegalStateException("Headers already written", errorExchange.getError());
        }
        if (errorExchange.getError() instanceof HttpException) {
            HttpException webError = (HttpException)errorExchange.getError();
            if (webError instanceof MethodNotAllowedException) {
                ((Response)errorExchange.response()).headers(headers -> headers.add((CharSequence)"allow", (CharSequence)((MethodNotAllowedException)webError).getAllowedMethods().stream().map(Enum::toString).collect(Collectors.joining(", "))));
            } else if (errorExchange.getError() instanceof ServiceUnavailableException) {
                ((ServiceUnavailableException)webError).getRetryAfter().ifPresent(retryAfter -> ((Response)errorExchange.response()).headers(headers -> headers.add((CharSequence)"retry-after", (CharSequence)retryAfter.format(Headers.FORMATTER_RFC_5322_DATE_TIME))));
            }
            ((Response)errorExchange.response()).headers(h -> h.status(webError.getStatusCode())).body().empty();
        } else {
            ((Response)errorExchange.response()).headers(h -> h.status(Status.INTERNAL_SERVER_ERROR)).body().empty();
        }
    }
}

