/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.InboundSetCookies;
import io.inverno.mod.http.base.OutboundResponseHeaders;
import io.inverno.mod.http.base.OutboundSetCookies;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.Status;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.GenericParameter;
import io.inverno.mod.http.base.internal.netty.LinkedHttpHeaders;
import io.inverno.mod.http.server.internal.GenericResponseCookies;
import io.inverno.mod.http.server.internal.InternalResponseHeaders;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

class Http1xResponseHeaders
implements InternalResponseHeaders {
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final LinkedHttpHeaders underlyingHeaders;
    private GenericResponseCookies responseCookies;
    private int statusCode = 200;
    private boolean written;

    public Http1xResponseHeaders(HeaderService headerService, ObjectConverter<String> parameterConverter) {
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.underlyingHeaders = new LinkedHttpHeaders();
    }

    LinkedHttpHeaders getUnderlyingHeaders() {
        return this.underlyingHeaders;
    }

    @Override
    public void setWritten(boolean written) {
        this.written = written;
    }

    public boolean isWritten() {
        return this.written;
    }

    public Http1xResponseHeaders status(Status status) {
        return this.status(status.getCode());
    }

    public Http1xResponseHeaders status(int status) {
        this.statusCode = status;
        return this;
    }

    public Status getStatus() {
        return Status.valueOf((int)this.statusCode);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Http1xResponseHeaders contentType(String contentType) {
        this.underlyingHeaders.set((CharSequence)"content-type", (Object)contentType);
        return this;
    }

    public String getContentType() {
        return this.underlyingHeaders.get((CharSequence)"content-type");
    }

    public Headers.ContentType getContentTypeHeader() {
        return this.getHeader("content-type").orElse(null);
    }

    @Override
    public CharSequence getContentTypeCharSequence() {
        return this.underlyingHeaders.getCharSequence((CharSequence)"content-type");
    }

    public Http1xResponseHeaders contentLength(long contentLength) {
        this.underlyingHeaders.setLong((CharSequence)"content-length", contentLength);
        return this;
    }

    public Long getContentLength() {
        return this.underlyingHeaders.getLong((CharSequence)"content-length");
    }

    public OutboundResponseHeaders cookies(Consumer<OutboundSetCookies> cookiesConfigurer) {
        if (this.responseCookies == null) {
            this.responseCookies = new GenericResponseCookies(this.headerService, this, this.parameterConverter);
        }
        cookiesConfigurer.accept(this.responseCookies);
        return this;
    }

    public InboundSetCookies cookies() {
        if (this.responseCookies == null) {
            this.responseCookies = new GenericResponseCookies(this.headerService, this, this.parameterConverter);
        }
        return this.responseCookies;
    }

    public Http1xResponseHeaders add(CharSequence name, CharSequence value) {
        this.underlyingHeaders.addCharSequence(name, value);
        return this;
    }

    public Http1xResponseHeaders add(Header ... headers) {
        for (Header header : headers) {
            this.underlyingHeaders.addCharSequence((CharSequence)header.getHeaderName(), (CharSequence)this.headerService.encodeValue(header));
        }
        return this;
    }

    public Http1xResponseHeaders set(CharSequence name, CharSequence value) {
        this.underlyingHeaders.setCharSequence(name, value);
        return this;
    }

    public Http1xResponseHeaders set(Header ... headers) {
        for (Header header : headers) {
            this.underlyingHeaders.setCharSequence((CharSequence)header.getHeaderName(), (CharSequence)this.headerService.encodeValue(header));
        }
        return this;
    }

    public Http1xResponseHeaders remove(CharSequence ... names) {
        for (CharSequence name : names) {
            this.underlyingHeaders.remove(name);
        }
        return this;
    }

    public boolean contains(CharSequence name) {
        return this.underlyingHeaders.contains(name);
    }

    public boolean contains(CharSequence name, CharSequence value) {
        return this.underlyingHeaders.contains(name, value, true);
    }

    public Set<String> getNames() {
        return this.underlyingHeaders.names();
    }

    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable(this.underlyingHeaders.get(name));
    }

    public List<String> getAll(CharSequence name) {
        return this.underlyingHeaders.getAll(name);
    }

    public List<Map.Entry<String, String>> getAll() {
        return this.underlyingHeaders.entries();
    }

    public <T extends Header> Optional<T> getHeader(CharSequence name) {
        return this.get(name).map(value -> this.headerService.decode(name.toString(), value));
    }

    public <T extends Header> List<T> getAllHeader(CharSequence name) {
        return this.getAll(name).stream().map(value -> this.headerService.decode(name.toString(), value)).collect(Collectors.toList());
    }

    public List<Header> getAllHeader() {
        return this.getAll().stream().map(e -> this.headerService.decode((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    public Optional<Parameter> getParameter(CharSequence name) {
        return this.get(name).map(value -> new GenericParameter(name.toString(), value, this.parameterConverter));
    }

    public List<Parameter> getAllParameter(CharSequence name) {
        return this.underlyingHeaders.getAll(name).stream().map(value -> new GenericParameter(name.toString(), value, this.parameterConverter)).collect(Collectors.toList());
    }

    public List<Parameter> getAllParameter() {
        return this.underlyingHeaders.entries().stream().map(e -> new GenericParameter((String)e.getKey(), (String)e.getValue(), this.parameterConverter)).collect(Collectors.toList());
    }

    @Override
    public CharSequence getCharSequence(CharSequence name) {
        return this.underlyingHeaders.getCharSequence(name);
    }

    @Override
    public List<CharSequence> getAllCharSequence(CharSequence name) {
        return this.underlyingHeaders.getAllCharSequence(name);
    }

    @Override
    public List<Map.Entry<CharSequence, CharSequence>> getAllCharSequence() {
        return this.underlyingHeaders.entriesCharSequence();
    }
}

