/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.base.net.URIBuilder;
import io.inverno.mod.http.base.InboundCookies;
import io.inverno.mod.http.base.InboundRequestHeaders;
import io.inverno.mod.http.base.Method;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.QueryParameters;
import io.inverno.mod.http.base.internal.GenericQueryParameters;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.Request;
import io.inverno.mod.http.server.RequestBody;
import io.inverno.mod.http.server.internal.GenericRequestBody;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandler;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.Optional;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reactor.core.publisher.Sinks;

public abstract class AbstractRequest
implements Request {
    private static final Logger LOGGER = LogManager.getLogger(AbstractRequest.class);
    protected final ChannelHandlerContext context;
    protected final InboundRequestHeaders requestHeaders;
    protected final ObjectConverter<String> parameterConverter;
    protected final MultipartDecoder<Parameter> urlEncodedBodyDecoder;
    protected final MultipartDecoder<Part> multipartBodyDecoder;
    private GenericRequestBody requestBody;
    private String pathAbsolute;
    private String queryString;
    protected GenericQueryParameters queryParameters;

    public AbstractRequest(ChannelHandlerContext context, InboundRequestHeaders requestHeaders, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder) {
        this.context = context;
        this.requestHeaders = requestHeaders;
        this.parameterConverter = parameterConverter;
        this.urlEncodedBodyDecoder = urlEncodedBodyDecoder;
        this.multipartBodyDecoder = multipartBodyDecoder;
    }

    protected abstract URIBuilder getPrimaryPathBuilder();

    public SocketAddress getLocalAddress() {
        return this.context.channel().localAddress();
    }

    public Optional<Certificate[]> getLocalCertificates() {
        return Optional.ofNullable((SslHandler)this.context.pipeline().get(SslHandler.class)).map(handler -> handler.engine().getSession().getLocalCertificates()).filter(certificates -> ((Certificate[])certificates).length > 0);
    }

    public SocketAddress getRemoteAddress() {
        return this.context.channel().remoteAddress();
    }

    public Optional<Certificate[]> getRemoteCertificates() {
        return Optional.ofNullable((SslHandler)this.context.pipeline().get(SslHandler.class)).map(handler -> {
            try {
                return handler.engine().getSession().getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                LOGGER.debug("Could not verify identity of the client", (Throwable)e);
                return null;
            }
        }).filter(certificates -> ((Certificate[])certificates).length > 0);
    }

    public String getPathAbsolute() {
        if (this.pathAbsolute == null) {
            this.pathAbsolute = this.getPrimaryPathBuilder().buildRawPath();
        }
        return this.pathAbsolute;
    }

    public URIBuilder getPathBuilder() {
        return this.getPrimaryPathBuilder().clone();
    }

    public String getQuery() {
        if (this.queryString == null) {
            this.queryString = this.getPrimaryPathBuilder().buildRawQuery();
        }
        return this.queryString;
    }

    public QueryParameters queryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = new GenericQueryParameters(this.getPrimaryPathBuilder().getQueryParameters(new Object[0]), this.parameterConverter);
        }
        return this.queryParameters;
    }

    public InboundRequestHeaders headers() {
        return this.requestHeaders;
    }

    @Override
    @Deprecated
    public InboundCookies cookies() {
        return this.requestHeaders.cookies();
    }

    public Optional<RequestBody> body() {
        if (this.requestBody == null) {
            Method method = this.getMethod();
            switch (method) {
                case POST: 
                case PUT: 
                case PATCH: 
                case DELETE: {
                    if (this.requestBody != null) break;
                    this.requestBody = new GenericRequestBody(this.headers().getHeader((CharSequence)"content-type"), this.urlEncodedBodyDecoder, this.multipartBodyDecoder);
                    break;
                }
                default: {
                    this.requestBody = null;
                }
            }
        }
        return Optional.ofNullable(this.requestBody);
    }

    public Optional<Sinks.Many<ByteBuf>> data() {
        return this.body().map(body -> ((GenericRequestBody)body).dataSink);
    }

    public void dispose() {
        this.dispose(null);
    }

    public void dispose(Throwable error) {
        if (this.requestBody != null) {
            this.requestBody.dispose(error);
        }
    }
}

