/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.multipart;

import io.inverno.mod.base.Charsets;
import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.InboundData;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.internal.multipart.PartHeaders;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCounted;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

class GenericPart
implements Part {
    private String name;
    private String filename;
    private PartHeaders partHeaders;
    private Flux<ByteBuf> data;
    private FluxSink<ByteBuf> dataEmitter;
    private InboundData<ByteBuf> rawData;
    private InboundData<CharSequence> stringData;

    public GenericPart(ObjectConverter<String> parameterConverter, String name, Map<String, List<Header>> headers) {
        this(parameterConverter, name, null, headers);
    }

    public GenericPart(ObjectConverter<String> parameterConverter, String name, String filename, Map<String, List<Header>> headers) {
        this.name = name;
        this.filename = filename;
        this.partHeaders = new PartHeaders(headers, parameterConverter);
        this.data = Flux.create(emitter -> {
            this.dataEmitter = emitter;
        }).doOnDiscard(ByteBuf.class, ReferenceCounted::release);
    }

    public Optional<FluxSink<ByteBuf>> getData() {
        return Optional.ofNullable(this.dataEmitter);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<String> getFilename() {
        return Optional.ofNullable(this.filename);
    }

    @Override
    public PartHeaders headers() {
        return this.partHeaders;
    }

    @Override
    public InboundData<ByteBuf> raw() {
        if (this.rawData == null) {
            this.rawData = new RawInboundData();
        }
        return this.rawData;
    }

    @Override
    public InboundData<CharSequence> string() {
        if (this.stringData == null) {
            this.stringData = new StringInboundData();
        }
        return this.stringData;
    }

    private class RawInboundData
    implements InboundData<ByteBuf> {
        private RawInboundData() {
        }

        public Publisher<ByteBuf> stream() {
            return GenericPart.this.data;
        }
    }

    private class StringInboundData
    implements InboundData<CharSequence> {
        private StringInboundData() {
        }

        public Publisher<CharSequence> stream() {
            return GenericPart.this.data.map(buf -> {
                try {
                    String string = buf.toString(Charsets.DEFAULT);
                    return string;
                }
                finally {
                    buf.release();
                }
            });
        }
    }
}

