/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x.ws;

import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.internal.ws.GenericWebSocketFrame;
import io.inverno.mod.http.base.internal.ws.GenericWebSocketMessage;
import io.inverno.mod.http.base.ws.WebSocketException;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.internal.http1x.ws.GenericWebSocketExchange;
import io.inverno.mod.http.server.ws.WebSocket;
import io.inverno.mod.http.server.ws.WebSocketExchange;
import io.inverno.mod.http.server.ws.WebSocketExchangeHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CorruptedWebSocketFrameException;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class WebSocketProtocolHandler
extends WebSocketServerProtocolHandler {
    private static final Logger LOGGER = LogManager.getLogger(WebSocket.class);
    private final WebSocketExchangeHandler<ExchangeContext, WebSocketExchange<ExchangeContext>> handler;
    private final Exchange<ExchangeContext> exchange;
    private final GenericWebSocketFrame.GenericFactory frameFactory;
    private final GenericWebSocketMessage.GenericFactory messageFactory;
    private final boolean closeOnOutboundComplete;
    private final long inboundCloseFrameTimeout;
    private final Sinks.One<Void> handshake;
    private GenericWebSocketExchange webSocketExchange;

    public WebSocketProtocolHandler(HttpServerConfiguration configuration, WebSocketServerProtocolConfig protocolConfig, WebSocketExchangeHandler<ExchangeContext, WebSocketExchange<ExchangeContext>> handler, Exchange<ExchangeContext> exchange, GenericWebSocketFrame.GenericFactory frameFactory, GenericWebSocketMessage.GenericFactory messageFactory) {
        super(protocolConfig);
        this.handler = handler;
        this.exchange = exchange;
        this.frameFactory = frameFactory;
        this.messageFactory = messageFactory;
        this.closeOnOutboundComplete = configuration.ws_close_on_outbound_complete();
        this.inboundCloseFrameTimeout = configuration.ws_inbound_close_frame_timeout();
        this.handshake = Sinks.one();
    }

    public Mono<Void> getHandshake() {
        return this.handshake.asMono();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
            WebSocketServerProtocolHandler.HandshakeComplete handshakeComplete = (WebSocketServerProtocolHandler.HandshakeComplete)evt;
            this.webSocketExchange = new GenericWebSocketExchange(ctx, this.exchange, handshakeComplete.selectedSubprotocol(), this.handler, this.frameFactory, this.messageFactory, this.closeOnOutboundComplete, this.inboundCloseFrameTimeout);
            this.handshake.tryEmitEmpty();
            this.webSocketExchange.start();
        } else if (evt == WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_TIMEOUT) {
            this.handshake.tryEmitError((Throwable)new WebSocketException("Handshake timeout"));
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    protected void decode(ChannelHandlerContext ctx, WebSocketFrame frame, List<Object> out) throws Exception {
        if (frame instanceof TextWebSocketFrame || frame instanceof BinaryWebSocketFrame || frame instanceof ContinuationWebSocketFrame) {
            this.webSocketExchange.inboundFrames().ifPresent(framesSink -> framesSink.tryEmitNext((Object)new GenericWebSocketFrame(frame.retain())));
        } else if (frame instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)frame;
            this.webSocketExchange.onCloseReceived((short)closeFrame.statusCode(), closeFrame.reasonText());
        } else {
            super.decode(ctx, frame, out);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        CorruptedWebSocketFrameException corruptedWSFrameException;
        if (this.webSocketExchange != null) {
            if (cause instanceof WebSocketHandshakeException) {
                LOGGER.error("WebSocket handshake error", cause);
                this.handshake.tryEmitError(cause);
                ctx.close();
            } else if (cause instanceof CorruptedWebSocketFrameException) {
                LOGGER.error("WebSocket procotol error", cause);
                corruptedWSFrameException = (CorruptedWebSocketFrameException)cause;
                this.webSocketExchange.close((short)corruptedWSFrameException.closeStatus().code(), corruptedWSFrameException.closeStatus().reasonText());
                this.webSocketExchange.dispose();
            } else {
                LOGGER.error("WebSocket procotol error", cause);
                this.webSocketExchange.dispose(cause);
                ChannelPromise closePromise = ctx.newPromise();
                ctx.close(closePromise);
                this.webSocketExchange.finalizeExchange(closePromise);
            }
        }
        if (cause instanceof WebSocketHandshakeException) {
            this.handshake.tryEmitError(cause);
        } else if (cause instanceof CorruptedWebSocketFrameException) {
            LOGGER.error("WebSocket procotol error", cause);
            corruptedWSFrameException = (CorruptedWebSocketFrameException)cause;
            this.webSocketExchange.close((short)corruptedWSFrameException.closeStatus().code(), corruptedWSFrameException.closeStatus().reasonText());
            this.webSocketExchange.dispose(cause);
        } else {
            LOGGER.error("WebSocket procotol error", cause);
            ctx.close();
        }
    }
}

